/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchCodecAwareSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchFieldProjection<E, P, F, V>
extends AbstractElasticsearchProjection<E, P> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private final String absoluteFieldPath;
    private final String[] absoluteFieldPathComponents;
    private final Function<JsonElement, F> decodeFunction;
    private final ProjectionConverter<? super F, ? extends V> converter;
    private final ProjectionAccumulator<F, V, E, P> accumulator;

    private ElasticsearchFieldProjection(Builder<F, V> builder, ProjectionAccumulator<F, V, E, P> accumulator) {
        this(((Builder)builder).searchContext, ((Builder)builder).field.absolutePath(), ((Builder)builder).field.absolutePathComponents(), ((Builder)builder).codec::decode, ((Builder)builder).converter, accumulator);
    }

    ElasticsearchFieldProjection(ElasticsearchSearchContext searchContext, String absoluteFieldPath, String[] absoluteFieldPathComponents, Function<JsonElement, F> decodeFunction, ProjectionConverter<? super F, ? extends V> converter, ProjectionAccumulator<F, V, E, P> accumulator) {
        super(searchContext);
        this.absoluteFieldPath = absoluteFieldPath;
        this.absoluteFieldPathComponents = absoluteFieldPathComponents;
        this.decodeFunction = decodeFunction;
        this.converter = converter;
        this.accumulator = accumulator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", accumulator=" + this.accumulator + "]";
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        JsonPrimitive fieldPathJson = new JsonPrimitive(this.absoluteFieldPath);
        REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)fieldPathJson);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        Object extracted = this.accumulator.createInitial();
        JsonObject source = (JsonObject)HIT_SOURCE_ACCESSOR.get(hit).get();
        extracted = this.collect(source, extracted, 0);
        return (E)extracted;
    }

    @Override
    public P transform(LoadingResult<?, ?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        FromDocumentFieldValueConvertContext convertContext = context.getFromDocumentFieldValueConvertContext();
        return (P)this.accumulator.finish(extractedData, this.converter, convertContext);
    }

    private E collect(JsonObject parent, E accumulated, int currentPathComponentIndex) {
        JsonElement child = parent.get(this.absoluteFieldPathComponents[currentPathComponentIndex]);
        if (currentPathComponentIndex == this.absoluteFieldPathComponents.length - 1) {
            if (child == null) {
                return accumulated;
            }
            if (child.isJsonNull()) {
                return (E)this.accumulator.accumulate(accumulated, null);
            }
            if (child.isJsonArray()) {
                for (JsonElement childElement : child.getAsJsonArray()) {
                    F decoded = this.decodeFunction.apply(childElement);
                    accumulated = this.accumulator.accumulate(accumulated, decoded);
                }
                return accumulated;
            }
            F decoded = this.decodeFunction.apply(child);
            return (E)this.accumulator.accumulate(accumulated, decoded);
        }
        if (child == null || child.isJsonNull()) {
            return accumulated;
        }
        if (child.isJsonArray()) {
            for (JsonElement childElement : child.getAsJsonArray()) {
                JsonObject childElementAsObject = this.toJsonObject(childElement, currentPathComponentIndex);
                accumulated = this.collect(childElementAsObject, accumulated, currentPathComponentIndex + 1);
            }
            return accumulated;
        }
        JsonObject childAsObject = this.toJsonObject(child, currentPathComponentIndex);
        return this.collect(childAsObject, accumulated, currentPathComponentIndex + 1);
    }

    private JsonObject toJsonObject(JsonElement childElement, int currentPathComponentIndex) {
        if (!JsonElementTypes.OBJECT.isInstance(childElement)) {
            throw new UnexpectedJsonElementTypeException(Arrays.stream(this.absoluteFieldPathComponents, 0, currentPathComponentIndex + 1).collect(Collectors.joining(".")), JsonElementTypes.OBJECT, childElement);
        }
        return childElement.getAsJsonObject();
    }

    public static class Builder<F, V>
    implements FieldProjectionBuilder<V> {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchContext searchContext;
        private final ElasticsearchSearchValueFieldContext<F> field;
        private final ProjectionConverter<F, ? extends V> converter;

        private Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field, ProjectionConverter<F, ? extends V> converter) {
            this.codec = codec;
            this.searchContext = searchContext;
            this.field = field;
            this.converter = converter;
        }

        public <R> SearchProjection<R> build(ProjectionAccumulator.Provider<V, R> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.field.multiValuedInRoot()) {
                throw log.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new ElasticsearchFieldProjection(this, accumulatorProvider.get());
        }
    }

    public static class TypeSelector<F> {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchContext searchContext;
        private final ElasticsearchSearchValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            this.codec = codec;
            this.searchContext = searchContext;
            this.field = field;
        }

        public <V> Builder<F, V> type(Class<V> expectedType, ValueConvert convert) {
            return new Builder(this.codec, this.searchContext, this.field, this.field.type().projectionConverter(convert).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchValueFieldQueryElementFactory<TypeSelector<?>, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            return new TypeSelector(this.codec, searchContext, field);
        }
    }
}

