/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface ElasticsearchSearchPredicate
extends SearchPredicate {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public void checkNestableWithin(String var1);

    public JsonObject toJsonQuery(PredicateRequestContext var1);

    public static ElasticsearchSearchPredicate from(ElasticsearchSearchContext searchContext, SearchPredicate predicate) {
        if (!(predicate instanceof ElasticsearchSearchPredicate)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherPredicates(predicate);
        }
        ElasticsearchSearchPredicate casted = (ElasticsearchSearchPredicate)predicate;
        if (!searchContext.indexes().hibernateSearchIndexNames().equals(casted.indexNames())) {
            throw log.predicateDefinedOnDifferentIndexes(predicate, casted.indexNames(), searchContext.indexes().hibernateSearchIndexNames());
        }
        return casted;
    }
}

