/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchDifferentNestedObjectCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchNestablePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.AssertionFailure;

public class ElasticsearchSimpleQueryStringPredicate
extends AbstractElasticsearchNestablePredicate {
    private static final JsonObjectAccessor SIMPLE_QUERY_STRING_ACCESSOR = JsonAccessor.root().property("simple_query_string").asObject();
    private static final JsonAccessor<String> QUERY_ACCESSOR = JsonAccessor.root().property("query").asString();
    private static final JsonAccessor<JsonElement> DEFAULT_OPERATOR_ACCESSOR = JsonAccessor.root().property("default_operator");
    private static final JsonAccessor<JsonArray> FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asArray();
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private static final JsonAccessor<String> FLAGS_ACCESSOR = JsonAccessor.root().property("flags").asString();
    private static final JsonPrimitive AND_OPERATOR_KEYWORD_JSON = new JsonPrimitive("and");
    private static final JsonPrimitive OR_OPERATOR_KEYWORD_JSON = new JsonPrimitive("or");
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final List<JsonPrimitive> fieldNameAndBoosts;
    private final JsonPrimitive defaultOperator;
    private final String simpleQueryString;
    private final String analyzer;
    private final EnumSet<SimpleQueryFlag> flags;

    ElasticsearchSimpleQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.nestedCompatibilityChecker.getNestedPathHierarchy();
        this.fieldPaths = new ArrayList(builder.fields.keySet());
        this.fieldNameAndBoosts = new ArrayList<JsonPrimitive>();
        for (ElasticsearchSimpleQueryStringPredicateBuilderFieldState fieldContext : builder.fields.values()) {
            this.fieldNameAndBoosts.add(fieldContext.build());
        }
        this.defaultOperator = builder.defaultOperator;
        this.simpleQueryString = builder.simpleQueryString;
        this.analyzer = builder.analyzer;
        this.flags = builder.flags;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY_ACCESSOR.set(innerObject, this.simpleQueryString);
        DEFAULT_OPERATOR_ACCESSOR.set(innerObject, (JsonElement)this.defaultOperator);
        JsonArray fieldArray = new JsonArray();
        for (JsonPrimitive fieldNameAndBoost : this.fieldNameAndBoosts) {
            fieldArray.add((JsonElement)fieldNameAndBoost);
        }
        FIELDS_ACCESSOR.set(innerObject, fieldArray);
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        if (this.flags != null) {
            StringBuilder flagsMask = new StringBuilder();
            for (SimpleQueryFlag flag : this.flags) {
                if (flagsMask.length() > 0) {
                    flagsMask.append("|");
                }
                flagsMask.append(this.getFlagName(flag));
            }
            FLAGS_ACCESSOR.set(innerObject, flagsMask.toString());
        }
        SIMPLE_QUERY_STRING_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    private String getFlagName(SimpleQueryFlag flag) {
        switch (flag) {
            case AND: {
                return "AND";
            }
            case NOT: {
                return "NOT";
            }
            case OR: {
                return "OR";
            }
            case PREFIX: {
                return "PREFIX";
            }
            case PHRASE: {
                return "PHRASE";
            }
            case PRECEDENCE: {
                return "PRECEDENCE";
            }
            case ESCAPE: {
                return "ESCAPE";
            }
            case WHITESPACE: {
                return "WHITESPACE";
            }
            case FUZZY: {
                return "FUZZY";
            }
            case NEAR: {
                return "SLOP";
            }
        }
        throw new AssertionFailure("Unexpected flag: " + flag);
    }

    public static class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements SimpleQueryStringPredicateBuilder {
        private final ElasticsearchSearchIndexesContext indexes;
        private final Map<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldState> fields = new LinkedHashMap<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldState>();
        private JsonPrimitive defaultOperator = ElasticsearchSimpleQueryStringPredicate.access$600();
        private String simpleQueryString;
        private String analyzer;
        private EnumSet<SimpleQueryFlag> flags;
        private ElasticsearchDifferentNestedObjectCompatibilityChecker nestedCompatibilityChecker;

        Builder(ElasticsearchSearchContext searchContext) {
            super(searchContext);
            this.indexes = searchContext.indexes();
            this.nestedCompatibilityChecker = ElasticsearchDifferentNestedObjectCompatibilityChecker.empty(this.indexes);
        }

        public void defaultOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    this.defaultOperator = AND_OPERATOR_KEYWORD_JSON;
                    break;
                }
                case OR: {
                    this.defaultOperator = OR_OPERATOR_KEYWORD_JSON;
                }
            }
        }

        public void flags(Set<SimpleQueryFlag> flags) {
            this.flags = EnumSet.copyOf(flags);
        }

        public SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
            ElasticsearchSimpleQueryStringPredicateBuilderFieldState field = this.fields.get(absoluteFieldPath);
            if (field == null) {
                field = this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SIMPLE_QUERY_STRING, this.searchContext);
                this.nestedCompatibilityChecker = this.nestedCompatibilityChecker.combineAndCheck(absoluteFieldPath);
                this.fields.put(absoluteFieldPath, field);
            }
            return field;
        }

        public void simpleQueryString(String simpleQueryString) {
            this.simpleQueryString = simpleQueryString;
        }

        public void analyzer(String analyzerName) {
            this.analyzer = analyzerName;
        }

        public void skipAnalysis() {
            this.analyzer("keyword");
        }

        public SearchPredicate build() {
            if (this.analyzer == null) {
                for (ElasticsearchSimpleQueryStringPredicateBuilderFieldState field : this.fields.values()) {
                    field.checkAnalyzerOrNormalizerCompatibleAcrossIndexes();
                }
            }
            return new ElasticsearchSimpleQueryStringPredicate(this);
        }
    }
}

