/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchSearchValueFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.AbstractElasticsearchDocumentValueSort;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDistanceSort
extends AbstractElasticsearchDocumentValueSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor GEO_DISTANCE_ACCESSOR = JsonAccessor.root().property("_geo_distance").asObject();
    private final GeoPoint center;

    private ElasticsearchDistanceSort(Builder builder) {
        super(builder);
        this.center = builder.center;
    }

    @Override
    protected void doToJsonSorts(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        innerObject.add(this.absoluteFieldPath, ElasticsearchGeoPointFieldCodec.INSTANCE.encode(this.center));
        if (this.indexNames.size() > 1) {
            this.searchSyntax.requestGeoDistanceSortIgnoreUnmapped(innerObject);
        }
        JsonObject outerObject = new JsonObject();
        GEO_DISTANCE_ACCESSOR.add(outerObject, innerObject);
        collector.collectDistanceSort((JsonElement)outerObject, this.absoluteFieldPath, this.center);
    }

    private static class Builder
    extends AbstractElasticsearchDocumentValueSort.AbstractBuilder<GeoPoint>
    implements DistanceSortBuilder {
        private GeoPoint center;

        private Builder(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            super(searchContext, field);
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        @Override
        public void mode(SortMode mode) {
            switch (mode) {
                case MIN: 
                case MAX: 
                case AVG: 
                case MEDIAN: {
                    super.mode(mode);
                    break;
                }
                default: {
                    throw log.invalidSortModeForDistanceSort(mode, this.field.eventContext());
                }
            }
        }

        public SearchSort build() {
            return new ElasticsearchDistanceSort(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchSearchValueFieldQueryElementFactory<DistanceSortBuilder, GeoPoint> {
        @Override
        public DistanceSortBuilder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            return new Builder(searchContext, field);
        }
    }
}

