/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBooleanPredicate
extends AbstractElasticsearchPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonObject> MUST_ACCESSOR = JsonAccessor.root().property("must").asObject();
    private static final JsonAccessor<JsonObject> MUST_NOT_ACCESSOR = JsonAccessor.root().property("must_not").asObject();
    private static final JsonAccessor<JsonObject> SHOULD_ACCESSOR = JsonAccessor.root().property("should").asObject();
    private static final JsonAccessor<JsonObject> FILTER_ACCESSOR = JsonAccessor.root().property("filter").asObject();
    private static final JsonAccessor<String> MINIMUM_SHOULD_MATCH_ACCESSOR = JsonAccessor.root().property("minimum_should_match").asString();
    private final List<ElasticsearchSearchPredicate> mustClauses;
    private final List<ElasticsearchSearchPredicate> mustNotClauses;
    private final List<ElasticsearchSearchPredicate> shouldClauses;
    private final List<ElasticsearchSearchPredicate> filterClauses;
    private final Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    private ElasticsearchBooleanPredicate(Builder builder) {
        super(builder);
        this.mustClauses = builder.mustClauses;
        this.mustNotClauses = builder.mustNotClauses;
        this.shouldClauses = builder.shouldClauses;
        this.filterClauses = builder.filterClauses;
        this.minimumShouldMatchConstraints = builder.minimumShouldMatchConstraints;
        builder.mustClauses = null;
        builder.mustNotClauses = null;
        builder.shouldClauses = null;
        builder.filterClauses = null;
        builder.minimumShouldMatchConstraints = null;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.checkNestableWithin(expectedParentNestedPath, this.mustClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.shouldClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.filterClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.mustNotClauses);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        this.contributeClauses(context, innerObject, MUST_ACCESSOR, this.mustClauses);
        this.contributeClauses(context, innerObject, MUST_NOT_ACCESSOR, this.mustNotClauses);
        this.contributeClauses(context, innerObject, SHOULD_ACCESSOR, this.shouldClauses);
        this.contributeClauses(context, innerObject, FILTER_ACCESSOR, this.filterClauses);
        if (this.minimumShouldMatchConstraints != null) {
            MINIMUM_SHOULD_MATCH_ACCESSOR.set(innerObject, this.formatMinimumShouldMatchConstraints(this.minimumShouldMatchConstraints));
        }
        outerObject.add("bool", (JsonElement)innerObject);
        return outerObject;
    }

    private void contributeClauses(PredicateRequestContext context, JsonObject innerObject, JsonAccessor<JsonObject> occurAccessor, List<ElasticsearchSearchPredicate> clauses) {
        if (clauses == null) {
            return;
        }
        for (ElasticsearchSearchPredicate clause : clauses) {
            occurAccessor.add(innerObject, clause.toJsonQuery(context));
        }
    }

    private void checkNestableWithin(String expectedParentNestedPath, List<ElasticsearchSearchPredicate> clauses) {
        if (clauses == null) {
            return;
        }
        for (ElasticsearchSearchPredicate clause : clauses) {
            clause.checkNestableWithin(expectedParentNestedPath);
        }
    }

    private String formatMinimumShouldMatchConstraints(Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, MinimumShouldMatchConstraint>> iterator = minimumShouldMatchConstraints.entrySet().iterator();
        Map.Entry<Integer, MinimumShouldMatchConstraint> entry = iterator.next();
        Integer ignoreConstraintCeiling = entry.getKey();
        MinimumShouldMatchConstraint constraint = entry.getValue();
        if (ignoreConstraintCeiling.equals(0) && minimumShouldMatchConstraints.size() == 1) {
            constraint.appendTo(builder, null);
            return builder.toString();
        }
        entry.getValue().appendTo(builder, ignoreConstraintCeiling);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ignoreConstraintCeiling = entry.getKey();
            constraint = entry.getValue();
            builder.append(' ');
            constraint.appendTo(builder, ignoreConstraintCeiling);
        }
        return builder.toString();
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        void appendTo(StringBuilder builder, Integer ignoreConstraintCeiling) {
            if (ignoreConstraintCeiling != null) {
                builder.append(ignoreConstraintCeiling).append('<');
            }
            if (this.matchingClausesNumber != null) {
                builder.append(this.matchingClausesNumber);
            } else {
                builder.append(this.matchingClausesPercent).append('%');
            }
        }
    }

    static class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements BooleanPredicateBuilder {
        private List<ElasticsearchSearchPredicate> mustClauses;
        private List<ElasticsearchSearchPredicate> mustNotClauses;
        private List<ElasticsearchSearchPredicate> shouldClauses;
        private List<ElasticsearchSearchPredicate> filterClauses;
        private Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

        Builder(ElasticsearchSearchContext searchContext) {
            super(searchContext);
        }

        public void must(SearchPredicate clause) {
            if (this.mustClauses == null) {
                this.mustClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.mustClauses.add(ElasticsearchSearchPredicate.from(this.searchContext, clause));
        }

        public void mustNot(SearchPredicate clause) {
            if (this.mustNotClauses == null) {
                this.mustNotClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.mustNotClauses.add(ElasticsearchSearchPredicate.from(this.searchContext, clause));
        }

        public void should(SearchPredicate clause) {
            if (this.shouldClauses == null) {
                this.shouldClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.shouldClauses.add(ElasticsearchSearchPredicate.from(this.searchContext, clause));
        }

        public void filter(SearchPredicate clause) {
            if (this.filterClauses == null) {
                this.filterClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.filterClauses.add(ElasticsearchSearchPredicate.from(this.searchContext, clause));
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(matchingClausesNumber, null));
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(null, matchingClausesPercent));
        }

        private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, MinimumShouldMatchConstraint constraint) {
            MinimumShouldMatchConstraint previous;
            if (this.minimumShouldMatchConstraints == null) {
                this.minimumShouldMatchConstraints = new TreeMap<Integer, MinimumShouldMatchConstraint>();
            }
            if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
                throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
            }
        }

        public SearchPredicate build() {
            if (this.minimumShouldMatchConstraints == null && this.hasAtLeastOneMustOrFilterPredicate()) {
                this.minimumShouldMatchNumber(0, 0);
            }
            return new ElasticsearchBooleanPredicate(this);
        }

        private boolean hasAtLeastOneMustOrFilterPredicate() {
            return this.mustClauses != null || this.filterClauses != null;
        }
    }
}

