/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.util.spi;

import com.google.gson.JsonElement;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;

public final class URLEncodedString {
    public final String encoded;
    public final String original;

    private URLEncodedString(String string) {
        this.original = string;
        try {
            this.encoded = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionFailure("Unexpected error retrieving the UTF-8 charset", (Throwable)e);
        }
    }

    public String toString() {
        return this.original;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (URLEncodedString.class != obj.getClass()) {
            return false;
        }
        URLEncodedString other = (URLEncodedString)obj;
        return this.original.equals(other.original);
    }

    public static URLEncodedString fromString(String string) {
        Contracts.assertNotNull((Object)string, (String)"string");
        return new URLEncodedString(string);
    }

    public static URLEncodedString fromJSon(JsonElement jsonElement) {
        Contracts.assertNotNull((Object)jsonElement, (String)"jsonElement");
        return URLEncodedString.fromString(jsonElement.getAsString());
    }
}

