/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.Analysis;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.metadata.impl.ElasticsearchIndexMetadataSyntax;

public class LowLevelIndexMetadataBuilder {
    private final ElasticsearchIndexMetadataSyntax syntax;
    private final IndexNames indexNames;
    private ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private IndexSettings customIndexSettings;
    private RootTypeMapping mapping;

    public LowLevelIndexMetadataBuilder(ElasticsearchIndexMetadataSyntax syntax, IndexNames indexNames) {
        this.syntax = syntax;
        this.indexNames = indexNames;
    }

    public void setAnalysisDefinitionRegistry(ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public void setCustomIndexSettings(IndexSettings customIndexSettings) {
        this.customIndexSettings = customIndexSettings;
    }

    public void setMapping(RootTypeMapping mapping) {
        this.mapping = mapping;
    }

    public IndexMetadata build() {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setAliases(this.buildAliases());
        indexMetadata.setSettings(this.buildSettings());
        indexMetadata.setMapping(this.mapping);
        return indexMetadata;
    }

    private Map<String, IndexAliasDefinition> buildAliases() {
        LinkedHashMap<String, IndexAliasDefinition> aliases = new LinkedHashMap<String, IndexAliasDefinition>();
        if (this.indexNames.writeIsAlias()) {
            aliases.put(this.indexNames.write().original, this.syntax.createWriteAliasDefinition());
        }
        if (this.indexNames.readIsAlias()) {
            aliases.put(this.indexNames.read().original, this.syntax.createReadAliasDefinition());
        }
        return aliases;
    }

    private IndexSettings buildSettings() {
        IndexSettings settings = new IndexSettings();
        if (!this.analysisDefinitionRegistry.getAnalyzerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setAnalyzers(this.analysisDefinitionRegistry.getAnalyzerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getNormalizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setNormalizers(this.analysisDefinitionRegistry.getNormalizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenizers(this.analysisDefinitionRegistry.getTokenizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenFilters(this.analysisDefinitionRegistry.getTokenFilterDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getCharFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setCharFilters(this.analysisDefinitionRegistry.getCharFilterDefinitions());
        }
        settings.merge(this.customIndexSettings);
        return settings;
    }

    private Analysis getAnalysis(IndexSettings settings) {
        Analysis analysis = settings.getAnalysis();
        if (analysis == null) {
            analysis = new Analysis();
            settings.setAnalysis(analysis);
        }
        return analysis;
    }
}

