/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchRequestFailed(ElasticsearchRequest request, ElasticsearchResponse response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchBulkedRequestFailed(JsonObject requestMetadata, JsonObject response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchStatus408RequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch response indicates a timeout (HTTP status 408)";
    }

    @Override
    public final SearchException elasticsearchStatus408RequestTimeout() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchStatus408RequestTimeout$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchMappingUpdateFailed$str() {
        return "HSEARCH400020: Unable to update mapping for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchMappingUpdateFailed(String indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }

    @Override
    public final SearchException invalidIndexStatus(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$sms.";
    }

    @Override
    public final SearchException unexpectedIndexStatus(URLEncodedString indexName, String expected, int requiredStatusTimeoutInMs, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatus$str(), indexName, expected, requiredStatusTimeoutInMs), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Unable to retrieve index metadata from Elasticsearch: %1$s";
    }

    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexMetadataRetrievalFailed$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Unable to update schema for index '%1$s': %2$s";
    }

    @Override
    public final SearchException schemaUpdateFailed(URLEncodedString indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexMissing$str() {
        return "HSEARCH400050: Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }

    @Override
    public final SearchException indexMissing(URLEncodedString write, URLEncodedString read) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexMissing$str(), write, read));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executingElasticsearchQuery(String path, Map<String, String> parameters, String bodyParts) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executingElasticsearchQuery$str(), (Object)path, parameters, (Object)bodyParts);
    }

    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }

    protected String tokenizerNamingConflict$str() {
        return "HSEARCH400055: Duplicate tokenizer definitions: '%1$s'. Tokenizer names must be unique.";
    }

    @Override
    public final SearchException tokenizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenizerNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String charFilterNamingConflict$str() {
        return "HSEARCH400056: Duplicate char filter definitions: '%1$s'. Char filter names must be unique.";
    }

    @Override
    public final SearchException charFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.charFilterNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenFilterNamingConflict$str() {
        return "HSEARCH400057: Duplicate token filter definitions: '%1$s'. Token filter names must be unique.";
    }

    @Override
    public final SearchException tokenFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenFilterNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Unable to update settings for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(Object indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSettingsUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void closedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedIndex$str(), indexName);
    }

    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void openedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.openedIndex$str(), indexName);
    }

    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void usingPasswordOverHttp() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), new Object[0]);
    }

    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH400075: Unable to apply analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e, eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTokenizerDefinition$str() {
        return "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    }

    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenizerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchCharFilterDefinition$str() {
        return "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    }

    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchCharFilterDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    }

    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenFilterDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToDetectElasticsearchVersion$str() {
        return "HSEARCH400080: Unable to detect the Elasticsearch version running on the cluster: %s";
    }

    @Override
    public final SearchException failedToDetectElasticsearchVersion(String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToDetectElasticsearchVersion$str(), causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedElasticsearchVersion$str() {
        return "HSEARCH400081: Incompatible Elasticsearch version running on the cluster: '%s'. Refer to the documentation to know which versions of Elasticsearch are compatible with Hibernate Search.";
    }

    @Override
    public final SearchException unsupportedElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedElasticsearchVersion$str(), version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executedRequestWithFailure(String method, HttpHost host, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executedRequestWithFailure$str(), new Object[]{method, host, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequestWithFailure$str() {
        return "HSEARCH400082: Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }

    @Override
    public final void unknownElasticsearchVersion(ElasticsearchVersion version) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownElasticsearchVersion$str(), (Object)version);
    }

    protected String unknownElasticsearchVersion$str() {
        return "HSEARCH400085: Unknown Elasticsearch version running on the cluster: '%s'. Hibernate Search may not work correctly. Consider updating to a newer version of Hibernate Search, if any.";
    }

    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s";
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }

    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseIndicatesFailure$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executedRequest(String method, HttpHost host, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executedRequest$str(), new Object[]{method, host, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequest$str() {
        return "HSEARCH400093: Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }

    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder baseScope, ElasticsearchIndexManager elasticsearchIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder baseScope, ElasticsearchIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.";
    }

    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Invalid tenant identifier: '%1$s'. The tenant identifier must be null, because multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Missing tenant identifier. The tenant identifier must be non-null, because multi-tenancy is enabled for this backend.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientUnwrappingWithUnkownType$str() {
        return "HSEARCH400518: Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException clientUnwrappingWithUnkownType(Class<?> requestedClass, Class<?> actualClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.clientUnwrappingWithUnkownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), name), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Missing data in the Elasticsearch response.";
    }

    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.elasticsearchResponseMissingData$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ceiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ceiling));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'";
    }

    @Override
    public final SearchException conflictingIndexNames(String firstHibernateSearchIndexName, String secondHibernateSearchIndexName, String nameOrAlias) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Unable to resolve index name '%1$s' to an entity type: %2$s";
    }

    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(String elasticsearchIndexName, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH400532: Unable to convert DSL argument: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    }

    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH400535: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH400536: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH400537: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, JsonElement value1, JsonElement value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToShutdownClient$str() {
        return "HSEARCH400544: Unable to shut down the Elasticsearch client: %1$s";
    }

    @Override
    public final SearchException unableToShutdownClient(String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToShutdownClient$str(), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: No built-in index field type for class: '%1$s'.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Full-text features (analysis, fuzziness) are not supported for fields of this type.";
    }

    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fullTextFeaturesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchVersionWithoutDistribution$str() {
        return "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.";
    }

    @Override
    public final SearchException invalidElasticsearchVersionWithoutDistribution(String invalidRepresentation, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersionWithoutDistribution$str(), invalidRepresentation), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchVersionWithOptionalDistribution$str() {
        return "HSEARCH400557: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier' or '<distribution>:x.y.z-qualifier', where '<distribution>' is one of %2$s (defaults to '%3$s'), 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example 'elastic:7.0', '7.0' or just '7'.";
    }

    @Override
    public final SearchException invalidElasticsearchVersionWithOptionalDistribution(String invalidRepresentation, List<String> validDistributions, String defaultDistribution, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersionWithOptionalDistribution$str(), invalidRepresentation, validDistributions, defaultDistribution), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchDistributionName$str() {
        return "HSEARCH400558: Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidElasticsearchDistributionName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchDistributionName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedElasticsearchVersion$str() {
        return "HSEARCH400559: Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.";
    }

    @Override
    public final SearchException unexpectedElasticsearchVersion(ElasticsearchVersion configuredVersion, ElasticsearchVersion actualVersion) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedElasticsearchVersion$str(), configuredVersion, actualVersion));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String skipAnalysisOnNormalizedField$str() {
        return "HSEARCH400560: Cannot skip analysis on field '%1$s': the Elasticsearch backend will always normalize arguments before attempting matches on normalized fields.";
    }

    @Override
    public final SearchException skipAnalysisOnNormalizedField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.skipAnalysisOnNormalizedField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousElasticsearchVersion$str() {
        return "HSEARCH400561: Ambiguous Elasticsearch version: '%s'. This version matches multiple dialects. Please use a more precise version to remove the ambiguity.";
    }

    @Override
    public final SearchException ambiguousElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ambiguousElasticsearchVersion$str(), version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH400562: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH400563: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absolutePath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresTypeName$str() {
        return "HSEARCH400564: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }

    @Override
    public final SearchException explainRequiresTypeName(Set<String> targetedTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeName$str(), targetedTypeNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH400565: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(Set<String> targetedTypeNames, String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Invalid document identifier: '%2$s'. No such document in index '%1$s'.";
    }

    @Override
    public final SearchException explainUnknownDocument(URLEncodedString indexName, URLEncodedString id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), indexName, id));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH400567: Invalid index field type: missing decimal scale. Define the decimal scale explicitly.";
    }

    @Override
    public final SearchException nullDecimalScale(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), new Object[0]), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH400569: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value, Number min, Number max) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value, min, max));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s, but the given predicate was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s, but the given sort was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort sort, Set<String> sortIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s, but the given projection was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> projection, Set<String> projectionIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH400576: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.";
    }

    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> range) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s, but the given aggregation was built from a scope targeting indexes %2$s.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Duplicate aggregation definitions for key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH400587: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: Call to the bulk REST API failed: %1$s";
    }

    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchFailedBecauseOfBulkFailure$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }

    @Override
    public final SearchException invalidHostAndPort(String hostAndPort, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidHostAndPort$str(), hostAndPort), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requestTimedOut$str() {
        return "HSEARCH400590: Request execution exceeded the timeout of %1$s. Request was %2$s";
    }

    @Override
    public final SearchTimeoutException requestTimedOut(Duration timeout, ElasticsearchRequest request) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.requestTimedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidTypeNameMappingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException missingTypeFieldInDocument(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingTypeFieldInDocument$str(), fieldName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.";
    }

    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString write, URLEncodedString read, Set<String> matchingIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.";
    }

    @Override
    public final SearchException invalidIndexPrimaryName(String elasticsearchIndexName, Pattern pattern) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.";
    }

    @Override
    public final SearchException invalidIndexUniqueKey(String uniqueKey, Set<String> knownKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.";
    }

    @Override
    public final SearchException sameWriteAndReadAliases(URLEncodedString writeAndReadAlias, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sameWriteAndReadAliases$str(), writeAndReadAlias), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String impreciseElasticsearchVersionWhenNoVersionCheck$str() {
        return "HSEARCH400597: Missing or imprecise Elasticsearch version: when configuration property '%1$s' is set to 'false',  the version is mandatory and must be at least as precise as 'x.y', where 'x' and 'y' are integers.";
    }

    @Override
    public final SearchException impreciseElasticsearchVersionWhenNoVersionCheck(String versionCheckPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.impreciseElasticsearchVersionWhenNoVersionCheck$str(), versionCheckPropertyKey));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String lifecycleStrategyMovedToMapper$str() {
        return "HSEARCH400598: The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.";
    }

    @Override
    public final SearchException lifecycleStrategyMovedToMapper() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.lifecycleStrategyMovedToMapper$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH400600: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }

    @Override
    public final SearchException invalidSortModeAcrossNested(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeAcrossNested$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSortModeForStringField$str() {
        return "HSEARCH400601: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }

    @Override
    public final SearchException invalidSortModeForStringField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForStringField$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH400602: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForTemporalField(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForTemporalField$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH400603: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }

    @Override
    public final SearchException invalidSortModeForDistanceSort(SortMode mode, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSortModeForDistanceSort$str(), mode), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH400604: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH400605: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }

    @Override
    public final SearchException invalidNestedObjectPathForPredicate(SearchPredicate predicate, String nestedObjectPath, List<String> fieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH400606: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }

    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH400607: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaFieldTemplateNameConflict$str(), name), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldValueType$str() {
        return "HSEARCH400608: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldValueType(Class<?> fieldValueType, Class<?> invalidValueType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldValueType$str(), new ClassFormatter(fieldValueType), new ClassFormatter(invalidValueType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForIndexing$str() {
        return "HSEARCH400609: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForIndexing(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForIndexing$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH400613: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.multi()' when you create the projection.";
    }

    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(String absolutePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH400617: Implementation class differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentImplementationClassForQueryElement(Class<?> class1, Class<?> class2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentImplementationClassForQueryElement$str(), new ClassFormatter(class1), new ClassFormatter(class2)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH400618: Field codec differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentFieldCodecForQueryElement(Object codec1, Object codec2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentFieldCodecForQueryElement$str(), codec1, codec2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDynamicType$str() {
        return "HSEARCH400621: Invalid dynamic type: '%1$s'. Valid values are: %2$s.";
    }

    @Override
    public final SearchException invalidDynamicType(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDynamicType$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchAliasUpdateFailed$str() {
        return "HSEARCH400625: Unable to update aliases for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchAliasUpdateFailed(Object indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchAliasUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String uriAndProtocol$str() {
        return "HSEARCH400626: Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }

    @Override
    public final SearchException uriAndProtocol(List<String> uris, String protocol) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uriAndProtocol$str(), uris, protocol));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String uriAndHosts$str() {
        return "HSEARCH400627: Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }

    @Override
    public final SearchException uriAndHosts(List<String> uris, List<String> hosts) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uriAndHosts$str(), uris, hosts));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentProtocolsOnUris$str() {
        return "HSEARCH400628: Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.";
    }

    @Override
    public final SearchException differentProtocolsOnUris(List<String> uris) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentProtocolsOnUris$str(), uris));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyListOfHosts$str() {
        return "HSEARCH400629: Invalid target hosts configuration: the list of hosts must not be empty.";
    }

    @Override
    public final SearchException emptyListOfHosts() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.emptyListOfHosts$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyListOfUris$str() {
        return "HSEARCH400630: Invalid target hosts configuration: the list of URIs must not be empty.";
    }

    @Override
    public final SearchException emptyListOfUris() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.emptyListOfUris$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexSettingsFileNotFound$str() {
        return "HSEARCH400631: Unable to find the given custom index settings file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexSettingsFileNotFound(String filePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsFileNotFound$str(), filePath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexSettingsErrorOnLoading$str() {
        return "HSEARCH400632: Error on loading the given custom index settings file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexSettingsErrorOnLoading(String filePath, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsErrorOnLoading$str(), filePath), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexSettingsJsonSyntaxErrors$str() {
        return "HSEARCH400633: There are some JSON syntax errors on the given custom index settings file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexSettingsJsonSyntaxErrors(String filePath, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexSettingsJsonSyntaxErrors$str(), filePath), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingFirstOnAscSortNotSupported$str() {
        return "HSEARCH400634: Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingFirstOnAscSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingFirstOnAscSortNotSupported$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingLastOnDescSortNotSupported$str() {
        return "HSEARCH400635: Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingLastOnDescSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingLastOnDescSortNotSupported$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingAsOnSortNotSupported$str() {
        return "HSEARCH400636: Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }

    @Override
    public final SearchException missingAsOnSortNotSupported(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingAsOnSortNotSupported$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH400637: The index schema named predicate '%1$s' was added twice.";
    }

    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(String relativeFilterName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentProviderForQueryElement$str() {
        return "HSEARCH400638: Provider differs: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException differentProviderForQueryElement(Object provider1, Object provider2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentProviderForQueryElement$str(), provider1, provider2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void defaultedLimitedHits(Integer defaultLimit, long hitCount) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultedLimitedHits$str(), (Object)defaultLimit, (Object)hitCount);
    }

    protected String defaultedLimitedHits$str() {
        return "HSEARCH400640: A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.";
    }

    protected String incompatibleElasticsearchVersionOnStart$str() {
        return "HSEARCH400641: Incompatible Elasticsearch version: version '%2$s' does not match version '%1$s' that was provided when the backend was created. You can provide a more precise version on startup, but you cannot override the version that was provided when the backend was created.";
    }

    @Override
    public final SearchException incompatibleElasticsearchVersionOnStart(ElasticsearchVersion versionOnCreation, ElasticsearchVersion versionOnStart) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleElasticsearchVersionOnStart$str(), versionOnCreation, versionOnStart));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH400648: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButExplicitlyDisabledByBackend$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH400649: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String paramNotDefined$str() {
        return "HSEARCH400650: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }

    @Override
    public final SearchException paramNotDefined(String name, String predicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), name, predicateName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexMappingFileNotFound$str() {
        return "HSEARCH400651: Unable to find the given custom index mapping file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexMappingFileNotFound(String filePath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingFileNotFound$str(), filePath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexMappingErrorOnLoading$str() {
        return "HSEARCH400652: Error on loading the given custom index mapping file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexMappingErrorOnLoading(String filePath, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingErrorOnLoading$str(), filePath), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String customIndexMappingJsonSyntaxErrors$str() {
        return "HSEARCH400653: There are some JSON syntax errors on the given custom index mapping file: '%1$s'.";
    }

    @Override
    public final SearchException customIndexMappingJsonSyntaxErrors(String filePath, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.customIndexMappingJsonSyntaxErrors$str(), filePath), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

