/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

public class ElasticsearchNestedPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonAccessor<String> PATH_ACCESSOR = JsonAccessor.root().property("path").asString();
    private static final JsonAccessor<JsonObject> QUERY_ACCESSOR = JsonAccessor.root().property("query").asObject();
    private static final JsonAccessor<Boolean> IGNORE_UNMAPPED_ACCESSOR = JsonAccessor.root().property("ignore_unmapped").asBoolean();
    private final ElasticsearchSearchPredicate nestedPredicate;

    private ElasticsearchNestedPredicate(Builder builder) {
        super(builder);
        this.nestedPredicate = builder.nestedPredicate;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        PredicateRequestContext nestedContext = context.withNestedPath(this.absoluteFieldPath);
        ElasticsearchNestedPredicate.wrap(this.indexNames(), this.absoluteFieldPath, outerObject, innerObject, this.nestedPredicate.toJsonQuery(nestedContext));
        return outerObject;
    }

    static void wrap(Set<String> indexNames, String absoluteFieldPath, JsonObject outerObject, JsonObject innerObject, JsonObject toWrap) {
        PATH_ACCESSOR.set(innerObject, absoluteFieldPath);
        QUERY_ACCESSOR.set(innerObject, toWrap);
        if (indexNames.size() > 1) {
            IGNORE_UNMAPPED_ACCESSOR.set(innerObject, true);
        }
        outerObject.add("nested", (JsonElement)innerObject);
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements NestedPredicateBuilder {
        private ElasticsearchSearchPredicate nestedPredicate;

        Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext field) {
            super(scope, field.absolutePath(), field.nestedPathHierarchy().subList(0, field.nestedPathHierarchy().size() - 1));
        }

        public void nested(SearchPredicate nestedPredicate) {
            ElasticsearchSearchPredicate elasticsearchPredicate = ElasticsearchSearchPredicate.from(this.scope, nestedPredicate);
            elasticsearchPredicate.checkNestableWithin(this.absoluteFieldPath);
            this.nestedPredicate = elasticsearchPredicate;
        }

        public SearchPredicate build() {
            return new ElasticsearchNestedPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<NestedPredicateBuilder> {
        public NestedPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new Builder(scope, node);
        }
    }
}

