/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.RegexpPredicateBuilder;

public class ElasticsearchTextRegexpPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor REGEXP_ACCESSOR = JsonAccessor.root().property("regexp").asObject();
    private static final JsonAccessor<JsonElement> VALUE_ACCESSOR = JsonAccessor.root().property("value");
    private final JsonPrimitive pattern;

    public ElasticsearchTextRegexpPredicate(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        VALUE_ACCESSOR.set(innerObject, (JsonElement)this.pattern);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        REGEXP_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements RegexpPredicateBuilder {
        private JsonPrimitive pattern;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            super(scope, field);
        }

        public void pattern(String pattern) {
            this.pattern = new JsonPrimitive(pattern);
        }

        public SearchPredicate build() {
            return new ElasticsearchTextRegexpPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<RegexpPredicateBuilder, String> {
        @Override
        public RegexpPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            return new Builder(scope, field);
        }
    }
}

