/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.DeleteWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class ElasticsearchIndexIndexer
implements IndexIndexer {
    private final ElasticsearchWorkBuilderFactory factory;
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public ElasticsearchIndexIndexer(ElasticsearchWorkBuilderFactory factory, ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.factory = factory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.index(referenceProvider, documentContributor, refreshStrategy);
    }

    public CompletableFuture<?> addOrUpdate(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.index(referenceProvider, documentContributor, refreshStrategy);
    }

    public CompletableFuture<?> delete(DocumentReferenceProvider referenceProvider, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        SingleDocumentIndexingWork work = (SingleDocumentIndexingWork)((DeleteWorkBuilder)this.factory.delete(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey).refresh(refreshStrategy)).build();
        return this.orchestrator.submit(work);
    }

    private CompletableFuture<?> index(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentRefreshStrategy refreshStrategy) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        SingleDocumentIndexingWork work = (SingleDocumentIndexingWork)((IndexWorkBuilder)this.factory.index(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey, document).refresh(refreshStrategy)).build();
        return this.orchestrator.submit(work);
    }
}

