/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;

public class ElasticsearchGeoPointSpatialWithinPolygonPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor GEO_POLYGON_ACCESSOR = JsonAccessor.root().property("geo_polygon").asObject();
    private static final JsonAccessor<Boolean> IGNORE_UNMAPPED_ACCESSOR = JsonAccessor.root().property("ignore_unmapped").asBoolean();
    private static final String POINTS_PROPERTY_NAME = "points";
    private final double[] coordinates;

    private ElasticsearchGeoPointSpatialWithinPolygonPredicate(Builder builder) {
        super(builder);
        this.coordinates = builder.coordinates;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonObject pointsObject = new JsonObject();
        JsonArray pointsArray = new JsonArray();
        for (int i = 0; i < this.coordinates.length; i += 2) {
            JsonArray point = new JsonArray();
            point.add((Number)this.coordinates[i]);
            point.add((Number)this.coordinates[i + 1]);
            pointsArray.add((JsonElement)point);
        }
        pointsObject.add(POINTS_PROPERTY_NAME, (JsonElement)pointsArray);
        innerObject.add(this.absoluteFieldPath, (JsonElement)pointsObject);
        if (this.indexNames().size() > 1) {
            IGNORE_UNMAPPED_ACCESSOR.set(innerObject, true);
        }
        GEO_POLYGON_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements SpatialWithinPolygonPredicateBuilder {
        private double[] coordinates;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void polygon(GeoPolygon polygon) {
            List points = polygon.points();
            this.coordinates = new double[points.size() * 2];
            int index = 0;
            for (GeoPoint point : points) {
                this.coordinates[index++] = point.longitude();
                this.coordinates[index++] = point.latitude();
            }
        }

        public SearchPredicate build() {
            return new ElasticsearchGeoPointSpatialWithinPolygonPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<SpatialWithinPolygonPredicateBuilder, GeoPoint> {
        @Override
        public Builder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

