/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicTemplate;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.NamedDynamicTemplate;

public class NamedDynamicTemplateJsonAdapterFactory
implements TypeAdapterFactory {
    private static final TypeToken<NamedDynamicTemplate> NAMED_DYNAMIC_TEMPLATE_TYPE_TOKEN = TypeToken.get(NamedDynamicTemplate.class);
    private static final TypeToken<DynamicTemplate> DYNAMIC_TEMPLATE_TYPE_TOKEN = TypeToken.get(DynamicTemplate.class);

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!NAMED_DYNAMIC_TEMPLATE_TYPE_TOKEN.equals(typeToken)) {
            return null;
        }
        TypeAdapter templateAdapter = gson.getAdapter(DYNAMIC_TEMPLATE_TYPE_TOKEN);
        return new Adapter((TypeAdapter<DynamicTemplate>)templateAdapter);
    }

    private static class Adapter
    extends TypeAdapter<NamedDynamicTemplate> {
        private final TypeAdapter<DynamicTemplate> templateAdapter;

        public Adapter(TypeAdapter<DynamicTemplate> templateAdapter) {
            this.templateAdapter = templateAdapter;
        }

        public void write(JsonWriter out, NamedDynamicTemplate value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(value.name);
            this.templateAdapter.write(out, (Object)value.template);
            out.endObject();
        }

        public NamedDynamicTemplate read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            String name = in.nextName();
            DynamicTemplate template = (DynamicTemplate)this.templateAdapter.read(in);
            in.endObject();
            return new NamedDynamicTemplate(name, template);
        }
    }
}

