/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;

public class ElasticsearchSchemaDropperImpl
implements ElasticsearchSchemaDropper {
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public ElasticsearchSchemaDropperImpl(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    @Override
    public CompletableFuture<?> dropIfExisting(IndexNames indexNames) {
        return this.schemaAccessor.getCurrentIndexMetadataOrNull(indexNames).thenCompose(existingIndexMetadata -> {
            if (existingIndexMetadata == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.schemaAccessor.dropIndexIfExisting(URLEncodedString.fromString(existingIndexMetadata.getPrimaryName()));
        });
    }
}

