/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

public class ElasticsearchIndexSchemaManager
implements IndexSchemaManager {
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaCreator schemaCreator;
    private final ElasticsearchSchemaDropper schemaDropper;
    private final ElasticsearchSchemaValidator schemaValidator;
    private final ElasticsearchSchemaMigrator schemaMigrator;
    private final IndexNames indexNames;
    private final IndexMetadata expectedMetadata;
    private final ElasticsearchIndexLifecycleExecutionOptions executionOptions;

    public ElasticsearchIndexSchemaManager(ElasticsearchWorkFactory workFactory, ElasticsearchParallelWorkOrchestrator workOrchestrator, IndexLayoutStrategy indexLayoutStrategy, IndexNames indexNames, IndexMetadata expectedMetadata, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.schemaAccessor = new ElasticsearchSchemaAccessor(workFactory, workOrchestrator);
        this.schemaCreator = new ElasticsearchSchemaCreator(this.schemaAccessor, indexLayoutStrategy);
        this.schemaDropper = new ElasticsearchSchemaDropper(this.schemaAccessor);
        this.schemaValidator = new ElasticsearchSchemaValidator();
        this.schemaMigrator = new ElasticsearchSchemaMigrator(this.schemaAccessor, this.schemaValidator);
        this.indexNames = indexNames;
        this.expectedMetadata = expectedMetadata;
        this.executionOptions = executionOptions;
    }

    public CompletableFuture<?> createIfMissing() {
        return this.schemaCreator.createIndexIfAbsent(this.indexNames, this.expectedMetadata).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, this.executionOptions));
    }

    public CompletableFuture<?> createOrValidate(ContextualFailureCollector failureCollector) {
        return ((CompletableFuture)this.schemaCreator.createIndexIfAbsent(this.indexNames, this.expectedMetadata).thenAccept(preExistingIndexMetadata -> {
            if (preExistingIndexMetadata != null) {
                this.schemaValidator.validate(this.expectedMetadata, preExistingIndexMetadata.getMetadata(), failureCollector);
            }
        })).thenCompose(ignored -> failureCollector.hasFailure() ? CompletableFuture.completedFuture(null) : this.schemaAccessor.waitForIndexStatus(this.indexNames, this.executionOptions));
    }

    public CompletableFuture<?> createOrUpdate() {
        return ((CompletableFuture)this.schemaCreator.createIndexIfAbsent(this.indexNames, this.expectedMetadata).thenCompose(existingIndexMetadata -> {
            if (existingIndexMetadata != null) {
                return this.schemaMigrator.migrate(URLEncodedString.fromString(existingIndexMetadata.getPrimaryName()), this.expectedMetadata, existingIndexMetadata.getMetadata());
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, this.executionOptions));
    }

    public CompletableFuture<?> dropIfExisting() {
        return this.schemaDropper.dropIfExisting(this.indexNames);
    }

    public CompletableFuture<?> dropAndCreate() {
        return ((CompletableFuture)this.schemaDropper.dropIfExisting(this.indexNames).thenCompose(ignored -> this.schemaCreator.createIndexAssumeNonExisting(this.indexNames, this.expectedMetadata))).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, this.executionOptions));
    }

    public CompletableFuture<?> validate(ContextualFailureCollector failureCollector) {
        return ((CompletableFuture)this.schemaAccessor.getCurrentIndexMetadata(this.indexNames).thenAccept(actualIndexMetadata -> this.schemaValidator.validate(this.expectedMetadata, actualIndexMetadata.getMetadata(), failureCollector))).thenCompose(ignored -> failureCollector.hasFailure() ? CompletableFuture.completedFuture(null) : this.schemaAccessor.waitForIndexStatus(this.indexNames, this.executionOptions));
    }
}

