/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.CloseIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.CreateIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DropIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.GetIndexMetadataWork;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.OpenIndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexAliasesWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexMappingWork;
import org.hibernate.search.backend.elasticsearch.work.impl.PutIndexSettingsWork;
import org.hibernate.search.backend.elasticsearch.work.impl.WaitForIndexStatusWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExistingIndexMetadata;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class ElasticsearchSchemaAccessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchParallelWorkOrchestrator orchestrator;

    public ElasticsearchSchemaAccessor(ElasticsearchWorkFactory workFactory, ElasticsearchParallelWorkOrchestrator orchestrator) {
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
    }

    public CompletableFuture<?> createIndexAssumeNonExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping) {
        CreateIndexWork work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).build();
        return this.execute(work);
    }

    public CompletableFuture<Boolean> createIndexIgnoreExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping) {
        CreateIndexWork work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).ignoreExisting().build();
        return this.execute(work).thenApply(CreateIndexResult.CREATED::equals);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames) {
        return this.getCurrentIndexMetadata(indexNames, false);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadataOrNull(IndexNames indexNames) {
        return this.getCurrentIndexMetadata(indexNames, true);
    }

    private CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames, boolean allowNull) {
        GetIndexMetadataWork work = this.getWorkFactory().getIndexMetadata().index(indexNames.write()).index(indexNames.read()).build();
        return ((CompletableFuture)this.execute(work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchIndexMetadataRetrievalFailed(e.getMessage(), Throwables.expectException((Throwable)e));
        }))).thenApply(list -> {
            if (list.isEmpty()) {
                if (allowNull) {
                    return null;
                }
                throw log.indexMissing(indexNames.write(), indexNames.read());
            }
            if (list.size() > 1) {
                throw log.elasticsearchIndexNameAndAliasesMatchMultipleIndexes(indexNames.write(), indexNames.read(), list.stream().map(ExistingIndexMetadata::getPrimaryName).collect(Collectors.toSet()));
            }
            return (ExistingIndexMetadata)list.get(0);
        });
    }

    public CompletableFuture<?> updateAliases(URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases) {
        PutIndexAliasesWork work = this.getWorkFactory().putIndexAliases(indexName, aliases).build();
        return this.execute(work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchAliasUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateSettings(URLEncodedString indexName, IndexSettings settings) {
        PutIndexSettingsWork work = this.getWorkFactory().putIndexSettings(indexName, settings).build();
        return this.execute(work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchSettingsUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        PutIndexMappingWork work = this.getWorkFactory().putIndexTypeMapping(indexName, mapping).build();
        return this.execute(work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchMappingUpdateFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> waitForIndexStatus(IndexNames indexNames, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        IndexStatus requiredIndexStatus = executionOptions.getRequiredStatus();
        int requiredStatusTimeoutInMs = executionOptions.getRequiredStatusTimeoutInMs();
        URLEncodedString name = indexNames.write();
        WaitForIndexStatusWork work = this.getWorkFactory().waitForIndexStatusWork(name, requiredIndexStatus, requiredStatusTimeoutInMs).build();
        return this.execute(work).exceptionally(Futures.handler(e -> {
            throw log.unexpectedIndexStatus(name, requiredIndexStatus.externalRepresentation(), requiredStatusTimeoutInMs, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> dropIndexIfExisting(URLEncodedString indexName) {
        DropIndexWork work = this.getWorkFactory().dropIndex(indexName).ignoreIndexNotFound().build();
        return this.execute(work);
    }

    public CompletableFuture<?> closeIndex(URLEncodedString indexName) {
        CloseIndexWork work = this.getWorkFactory().closeIndex(indexName).build();
        return this.execute(work).thenRun(() -> log.closedIndex(indexName));
    }

    public CompletableFuture<?> openIndex(URLEncodedString indexName) {
        OpenIndexWork work = this.getWorkFactory().openIndex(indexName).build();
        return this.execute(work).thenRun(() -> log.openedIndex(indexName));
    }

    private ElasticsearchWorkFactory getWorkFactory() {
        return this.workFactory;
    }

    private <T> CompletableFuture<T> execute(NonBulkableWork<T> work) {
        return this.orchestrator.submit(work);
    }
}

