/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.factories.NamedPredicateProvider;
import org.hibernate.search.engine.search.predicate.factories.NamedPredicateProviderContext;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchNamedPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchPredicate providedPredicate;

    private ElasticsearchNamedPredicate(Builder builder, ElasticsearchSearchPredicate providedPredicate) {
        super(builder);
        this.providedPredicate = providedPredicate;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.providedPredicate.checkNestableWithin(expectedParentNestedPath);
        super.checkNestableWithin(expectedParentNestedPath);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        return this.providedPredicate.toJsonQuery(context);
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        private final NamedPredicateProvider provider;
        private final String predicateName;
        private final ElasticsearchSearchIndexCompositeNodeContext field;
        private SearchPredicateFactory factory;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(NamedPredicateProvider provider, String predicateName, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.provider = provider;
            this.predicateName = predicateName;
            this.field = node;
        }

        public void factory(SearchPredicateFactory factory) {
            this.factory = factory;
        }

        public void param(String name, Object value) {
            this.params.put(name, value);
        }

        public SearchPredicate build() {
            ElasticsearchNamedPredicateProviderContext ctx = new ElasticsearchNamedPredicateProviderContext(this.factory, this.field, this.predicateName, this.params);
            ElasticsearchSearchPredicate providedPredicate = ElasticsearchSearchPredicate.from(this.scope, this.provider.create((NamedPredicateProviderContext)ctx));
            return new ElasticsearchNamedPredicate(this, providedPredicate);
        }
    }

    private static class ElasticsearchNamedPredicateProviderContext
    implements NamedPredicateProviderContext {
        private final SearchPredicateFactory factory;
        private final ElasticsearchSearchIndexCompositeNodeContext field;
        private final String predicateName;
        private final Map<String, Object> params;

        ElasticsearchNamedPredicateProviderContext(SearchPredicateFactory factory, ElasticsearchSearchIndexCompositeNodeContext field, String predicateName, Map<String, Object> params) {
            this.factory = factory;
            this.field = field;
            this.predicateName = predicateName;
            this.params = params;
        }

        public SearchPredicateFactory predicate() {
            return this.factory;
        }

        public Object param(String name) {
            Contracts.assertNotNull((Object)name, (String)"name");
            Object value = this.params.get(name);
            if (value == null) {
                throw log.paramNotDefined(name, this.predicateName, this.field.eventContext());
            }
            return value;
        }

        public Optional<Object> paramOptional(String name) {
            Contracts.assertNotNull((Object)name, (String)"name");
            return Optional.ofNullable(this.params.get(name));
        }
    }

    public static class Factory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final NamedPredicateProvider provider;
        private final String predicateName;

        public Factory(NamedPredicateProvider provider, String predicateName) {
            this.provider = provider;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.provider.equals(castedOther.provider)) {
                throw log.differentProviderForQueryElement(this.provider, castedOther.provider);
            }
        }

        public NamedPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new Builder(this.provider, this.predicateName, scope, node);
        }
    }
}

