/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchConstantProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDocumentReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchExplanationProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchIdProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchJsonHitProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchScoreProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSourceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.common.spi.SearchIndexIdentifierContext;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class ElasticsearchSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final DocumentReferenceExtractionHelper documentReferenceExtractionHelper;
    private final ProjectionExtractionHelper<String> idProjectionExtractionHelper;

    public ElasticsearchSearchProjectionBuilderFactory(SearchProjectionBackendContext searchProjectionBackendContext, ElasticsearchSearchIndexScope<?> scope) {
        this.scope = scope;
        this.documentReferenceExtractionHelper = searchProjectionBackendContext.createDocumentReferenceExtractionHelper(scope);
        this.idProjectionExtractionHelper = searchProjectionBackendContext.idProjectionExtractionHelper();
    }

    public SearchProjection<DocumentReference> documentReference() {
        return new ElasticsearchDocumentReferenceProjection(this.scope, this.documentReferenceExtractionHelper);
    }

    public <E> SearchProjection<E> entity() {
        return new ElasticsearchEntityProjection(this.scope, this.documentReferenceExtractionHelper);
    }

    public <R> SearchProjection<R> entityReference() {
        return new ElasticsearchEntityReferenceProjection(this.scope, this.documentReferenceExtractionHelper);
    }

    public <I> SearchProjection<I> id(Class<I> identifierType) {
        SearchIndexIdentifierContext identifier = this.scope.identifier();
        return new ElasticsearchIdProjection(this.scope, this.idProjectionExtractionHelper, identifier.projectionConverter().withConvertedType(identifierType, (EventContextProvider)identifier));
    }

    public SearchProjection<Float> score() {
        return new ElasticsearchScoreProjection(this.scope);
    }

    public CompositeProjectionBuilder composite() {
        return new ElasticsearchCompositeProjection.Builder(this.scope);
    }

    public <T> SearchProjection<T> constant(T value) {
        return new ElasticsearchConstantProjection<T>(this.scope, value);
    }

    public SearchProjection<JsonObject> source() {
        return new ElasticsearchSourceProjection(this.scope);
    }

    public SearchProjection<JsonObject> explanation() {
        return new ElasticsearchExplanationProjection(this.scope);
    }

    public SearchProjection<JsonObject> jsonHit() {
        return new ElasticsearchJsonHitProjection(this.scope);
    }
}

