/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchSourceProjection
extends AbstractElasticsearchProjection<JsonObject>
implements ElasticsearchSearchProjection.Extractor<JsonObject, JsonObject> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonPrimitive WILDCARD_ALL = new JsonPrimitive("*");

    ElasticsearchSourceProjection(ElasticsearchSearchIndexScope<?> scope) {
        super(scope);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, JsonObject> request(JsonObject requestBody, ProjectionRequestContext context) {
        REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)WILDCARD_ALL);
        return this;
    }

    @Override
    public JsonObject extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
        return source;
    }

    @Override
    public JsonObject transform(LoadingResult<?, ?> loadingResult, JsonObject extractedData, ProjectionTransformContext context) {
        return extractedData;
    }
}

