/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.FieldProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchSearchQueryRequestContext
implements ProjectionRequestContext,
AggregationRequestContext {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContext<?, ?> loadingContext;
    private final PredicateRequestContext rootPredicateContext;
    private final Map<DistanceSortKey, Integer> distanceSorts;

    ElasticsearchSearchQueryRequestContext(ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContext<?, ?> loadingContext, PredicateRequestContext rootPredicateContext, Map<DistanceSortKey, Integer> distanceSorts) {
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.rootPredicateContext = rootPredicateContext;
        this.distanceSorts = distanceSorts != null ? Collections.unmodifiableMap(distanceSorts) : null;
    }

    @Override
    public PredicateRequestContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public Integer getDistanceSortIndex(String absoluteFieldPath, GeoPoint location) {
        if (this.distanceSorts == null) {
            return null;
        }
        return this.distanceSorts.get(new DistanceSortKey(absoluteFieldPath, location));
    }

    @Override
    public ElasticsearchSearchSyntax getSearchSyntax() {
        return this.scope.searchSyntax();
    }

    @Override
    public void checkValidField(String absoluteFieldPath) {
    }

    @Override
    public ProjectionRequestContext forField(String absoluteFieldPath, String[] absoluteFieldPathComponents) {
        return new FieldProjectionRequestContext(this, absoluteFieldPath, absoluteFieldPathComponents);
    }

    @Override
    public String absoluteCurrentFieldPath() {
        return null;
    }

    @Override
    public String[] relativeCurrentFieldPathComponents() {
        return null;
    }

    ElasticsearchSearchQueryExtractContext createExtractContext(JsonObject responseBody) {
        return new ElasticsearchSearchQueryExtractContext(this, this.sessionContext, this.loadingContext.createProjectionHitMapper(), responseBody);
    }
}

