/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScroll;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScrollResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchScrollResultImpl;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.SearchWork;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class ElasticsearchSearchScrollImpl<H>
implements ElasticsearchSearchScroll<H> {
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private final String scrollTimeoutString;
    private final SearchWork.Builder<ElasticsearchLoadableSearchResult<H>> firstScroll;
    private final TimeoutManager timeoutManager;
    private String scrollId;

    public ElasticsearchSearchScrollImpl(ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchWorkFactory workFactory, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, String scrollTimeoutString, SearchWork.Builder<ElasticsearchLoadableSearchResult<H>> firstScroll, TimeoutManager timeoutManager) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchResultExtractor = searchResultExtractor;
        this.scrollTimeoutString = scrollTimeoutString;
        this.firstScroll = firstScroll;
        this.timeoutManager = timeoutManager;
    }

    public void close() {
        if (this.scrollId != null) {
            Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(this.workFactory.clearScroll(this.scrollId).build()));
        }
    }

    public ElasticsearchSearchScrollResult<H> next() {
        this.timeoutManager.start();
        AbstractNonBulkableWork scroll = this.scrollId == null ? this.firstScroll.build() : this.workFactory.scroll(this.scrollId, this.scrollTimeoutString, this.searchResultExtractor).deadline(this.timeoutManager.deadlineOrNull(), this.timeoutManager.hasHardTimeout()).build();
        ElasticsearchLoadableSearchResult loadableSearchResult = (ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(scroll));
        ElasticsearchSearchResultImpl searchResult = loadableSearchResult.loadBlocking();
        this.scrollId = searchResult.scrollId();
        if (this.scrollId == null) {
            throw new AssertionFailure("Elasticsearch response lacked a value for scroll id");
        }
        this.timeoutManager.stop();
        return new ElasticsearchSearchScrollResultImpl(searchResult.total(), loadableSearchResult.hasHits(), searchResult.hits(), searchResult.took(), searchResult.timedOut());
    }
}

