/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchLongFieldCodec
implements ElasticsearchFieldCodec<Long> {
    public static final ElasticsearchLongFieldCodec INSTANCE = new ElasticsearchLongFieldCodec();

    private ElasticsearchLongFieldCodec() {
    }

    @Override
    public JsonElement encode(Long value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public JsonElement encodeForAggregation(ElasticsearchSearchSyntax searchSyntax, Long value) {
        return searchSyntax.encodeLongForAggregation(value);
    }

    @Override
    public Long decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.LONG.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

