/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.TermsPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchTermsPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor TERMS_ACCESSOR = JsonAccessor.root().property("terms").asObject();
    private static final JsonObjectAccessor TERM_ACCESSOR = JsonAccessor.root().property("term").asObject();
    private static final JsonObjectAccessor BOOL_ACCESSOR = JsonAccessor.root().property("bool").asObject();
    private static final JsonArrayAccessor MUST_ACCESSOR = JsonAccessor.root().property("must").asArray();
    private static final JsonAccessor<JsonElement> VALUE_ACCESSOR = JsonAccessor.root().property("value");
    private final JsonElement term;
    private final JsonElement[] terms;
    private boolean allMatch;

    public ElasticsearchTermsPredicate(Builder<?> builder) {
        super(builder);
        this.term = ((Builder)builder).term;
        this.terms = ((Builder)builder).terms;
        this.allMatch = ((Builder)builder).allMatch;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.term != null) {
            VALUE_ACCESSOR.set(innerObject, this.term);
            JsonObject middleObject = new JsonObject();
            middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
            TERM_ACCESSOR.set(outerObject, middleObject);
            return outerObject;
        }
        if (!this.allMatch) {
            JsonArray jsonArray = new JsonArray(this.terms.length);
            for (JsonElement element : this.terms) {
                jsonArray.add(element);
            }
            innerObject.add(this.absoluteFieldPath, (JsonElement)jsonArray);
            TERMS_ACCESSOR.set(outerObject, innerObject);
            return outerObject;
        }
        JsonArray termsArray = new JsonArray();
        for (JsonElement element : this.terms) {
            JsonObject innerTermObject = new JsonObject();
            innerTermObject.add(this.absoluteFieldPath, element);
            JsonObject termObject = new JsonObject();
            TERM_ACCESSOR.set(termObject, innerTermObject);
            termsArray.add((JsonElement)termObject);
        }
        MUST_ACCESSOR.set(innerObject, termsArray);
        BOOL_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private static class Builder<F>
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements TermsPredicateBuilder {
        private final ElasticsearchSearchIndexValueFieldContext<F> field;
        private final ElasticsearchFieldCodec<F> codec;
        private JsonElement term;
        private JsonElement[] terms;
        private boolean allMatch;

        private Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.constantScore();
            this.field = field;
            this.codec = codec;
        }

        public void matchingAny(Collection<?> terms, ValueConvert convert) {
            this.allMatch = false;
            this.fillTerms(terms, convert);
        }

        public void matchingAll(Collection<?> terms, ValueConvert convert) {
            this.allMatch = true;
            this.fillTerms(terms, convert);
        }

        public SearchPredicate build() {
            return new ElasticsearchTermsPredicate(this);
        }

        private void fillTerms(Collection<?> terms, ValueConvert convert) {
            DslConverter dslConverter = this.field.type().dslConverter(convert);
            if (terms.size() == 1) {
                this.term = this.encode(terms.iterator().next(), dslConverter);
                this.terms = null;
                return;
            }
            this.term = null;
            this.terms = this.encode(terms, dslConverter);
        }

        private JsonElement[] encode(Collection<?> terms, DslConverter<?, F> dslConverter) {
            JsonElement[] result = new JsonElement[terms.size()];
            int i = 0;
            for (Object term : terms) {
                result[i++] = this.encode(term, dslConverter);
            }
            return result;
        }

        private JsonElement encode(Object term, DslConverter<?, F> dslConverter) {
            try {
                Object converted = dslConverter.unknownTypeToDocumentValue(term, this.scope.toDocumentValueConvertContext());
                return this.codec.encode(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
            }
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<TermsPredicateBuilder, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TermsPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new Builder(this.codec, scope, field);
        }
    }
}

