/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexingPlanExecution;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.DeleteWork;
import org.hibernate.search.backend.elasticsearch.work.impl.IndexWork;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;

public class ElasticsearchIndexIndexingPlan
implements IndexIndexingPlan {
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;
    private final DocumentRefreshStrategy refreshStrategy;
    private final List<SingleDocumentIndexingWork> works = new ArrayList<SingleDocumentIndexingWork>();

    public ElasticsearchIndexIndexingPlan(ElasticsearchWorkFactory workFactory, ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext, DocumentRefreshStrategy refreshStrategy) {
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
        this.refreshStrategy = refreshStrategy;
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void addOrUpdate(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, referenceProvider.identifier());
        String routingKey = referenceProvider.routingKey();
        this.collect(((DeleteWork.Builder)this.workFactory.delete(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey).refresh(this.refreshStrategy)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory) {
        try {
            ElasticsearchIndexIndexingPlanExecution<R> execution = new ElasticsearchIndexIndexingPlanExecution<R>(this.orchestrator, entityReferenceFactory, new ArrayList<SingleDocumentIndexingWork>(this.works));
            CompletableFuture<MultiEntityOperationExecutionReport<R>> completableFuture = execution.execute();
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    public void discard() {
        this.works.clear();
    }

    private void index(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        this.collect(((IndexWork.Builder)this.workFactory.index(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey, document).refresh(this.refreshStrategy)).build());
    }

    private void collect(SingleDocumentIndexingWork work) {
        this.works.add(work);
    }
}

