/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractNonBulkableWork<R>
implements NonBulkableWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final CompletableFuture<Void> SUCCESSFUL_FUTURE = CompletableFuture.completedFuture(null);
    protected final ElasticsearchRequest request;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;

    protected AbstractNonBulkableWork(AbstractBuilder<?> builder) {
        this.request = ((AbstractBuilder)builder).buildRequestAndTransformIfNecessary();
        this.resultAssessor = builder.resultAssessor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "path = " + this.request.path() + "]";
    }

    @Override
    public final CompletableFuture<R> execute(ElasticsearchWorkExecutionContext executionContext) {
        return ((CompletableFuture)((CompletableFuture)Futures.create(() -> this.beforeExecute(executionContext, this.request)).thenCompose(ignored -> executionContext.getClient().submit(this.request))).exceptionally(Futures.handler(throwable -> {
            if (throwable instanceof SearchException) {
                throw (SearchException)((Object)throwable);
            }
            throw log.elasticsearchRequestFailed(this.request, null, throwable.getMessage(), Throwables.expectException((Throwable)throwable));
        }))).thenApply(response -> this.handleResult(executionContext, (ElasticsearchResponse)response));
    }

    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return SUCCESSFUL_FUTURE;
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, ElasticsearchResponse var2);

    private R handleResult(ElasticsearchWorkExecutionContext executionContext, ElasticsearchResponse response) {
        R result;
        try {
            this.resultAssessor.checkSuccess(response);
            result = this.generateResult(executionContext, response);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchRequestFailed(this.request, response, e.getMessage(), e);
        }
        return result;
    }

    protected static abstract class AbstractBuilder<B> {
        protected ElasticsearchRequestSuccessAssessor resultAssessor;
        private Function<ElasticsearchRequest, ElasticsearchRequest> requestTransformer;

        public AbstractBuilder(ElasticsearchRequestSuccessAssessor resultAssessor) {
            this.resultAssessor = resultAssessor;
        }

        public B requestTransformer(Function<ElasticsearchRequest, ElasticsearchRequest> requestTransformer) {
            this.requestTransformer = requestTransformer;
            return (B)this;
        }

        private ElasticsearchRequest buildRequestAndTransformIfNecessary() {
            ElasticsearchRequest request = this.buildRequest();
            if (this.requestTransformer != null) {
                request = this.requestTransformer.apply(request);
            }
            return request;
        }

        protected abstract ElasticsearchRequest buildRequest();

        public abstract AbstractNonBulkableWork<?> build();
    }
}

