/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNamedPredicateOptions;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexObjectFieldBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexObjectFieldTemplateBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexRootBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexValueFieldBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexValueFieldTemplateBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexCompositeNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchNamedPredicate;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexCompositeNodeType;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaNamedPredicateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchIndexCompositeNodeBuilder
implements IndexCompositeNodeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final ElasticsearchIndexCompositeNodeType.Builder typeBuilder;
    private final Map<String, ElasticsearchIndexNodeContributor> fields = new LinkedHashMap<String, ElasticsearchIndexNodeContributor>();
    private final Map<String, ElasticsearchIndexNodeContributor> templates = new LinkedHashMap<String, ElasticsearchIndexNodeContributor>();
    private final Map<String, ElasticsearchIndexNamedPredicateOptions> namedPredicates = new LinkedHashMap<String, ElasticsearchIndexNamedPredicateOptions>();

    protected AbstractElasticsearchIndexCompositeNodeBuilder(ElasticsearchIndexCompositeNodeType.Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldInclusion inclusion, IndexFieldType<F> indexFieldType) {
        ElasticsearchIndexValueFieldType fieldType = (ElasticsearchIndexValueFieldType)indexFieldType;
        ElasticsearchIndexValueFieldBuilder childBuilder = new ElasticsearchIndexValueFieldBuilder(this, relativeFieldName, inclusion, fieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public IndexObjectFieldBuilder addObjectField(String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        ElasticsearchIndexObjectFieldBuilder objectFieldBuilder = new ElasticsearchIndexObjectFieldBuilder(this, relativeFieldName, inclusion, structure);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaNamedPredicateOptionsStep addNamedPredicate(String name, IndexFieldInclusion inclusion, PredicateDefinition definition) {
        ElasticsearchIndexNamedPredicateOptions options = new ElasticsearchIndexNamedPredicateOptions(inclusion, definition);
        this.putNamedPredicate(name, options);
        if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
            this.typeBuilder.queryElementFactory(PredicateTypeKeys.named((String)name), new ElasticsearchNamedPredicate.Factory(options.definition, name));
        }
        return options;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addFieldTemplate(String templateName, IndexFieldInclusion inclusion, IndexFieldType<?> indexFieldType, String prefix) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        ElasticsearchIndexValueFieldType fieldType = (ElasticsearchIndexValueFieldType)indexFieldType;
        ElasticsearchIndexValueFieldTemplateBuilder templateBuilder = new ElasticsearchIndexValueFieldTemplateBuilder(this, prefixedTemplateName, inclusion, fieldType, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addObjectFieldTemplate(String templateName, ObjectStructure structure, String prefix, IndexFieldInclusion inclusion) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        ElasticsearchIndexObjectFieldTemplateBuilder templateBuilder = new ElasticsearchIndexObjectFieldTemplateBuilder(this, prefixedTemplateName, inclusion, structure, prefix);
        if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
            this.putTemplate(prefixedTemplateName, templateBuilder);
        }
        return templateBuilder;
    }

    final void contributeChildren(AbstractTypeMapping mapping, ElasticsearchIndexCompositeNode node, ElasticsearchIndexNodeCollector collector, Map<String, ElasticsearchIndexField> staticChildrenByNameForParent) {
        for (Map.Entry<String, ElasticsearchIndexNodeContributor> entry : this.fields.entrySet()) {
            ElasticsearchIndexNodeContributor propertyContributor = entry.getValue();
            propertyContributor.contribute(collector, node, staticChildrenByNameForParent, mapping);
        }
        for (ElasticsearchIndexNodeContributor template : this.templates.values()) {
            template.contribute(collector, node, staticChildrenByNameForParent, mapping);
        }
    }

    abstract ElasticsearchIndexRootBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final DynamicType resolveSelfDynamicType(DynamicType defaultDynamicType) {
        return this.templates.isEmpty() ? defaultDynamicType : DynamicType.TRUE;
    }

    private void putField(String name, ElasticsearchIndexNodeContributor contributor) {
        ElasticsearchIndexNodeContributor previous = this.fields.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.eventContext());
        }
    }

    private void putTemplate(String name, ElasticsearchIndexNodeContributor contributor) {
        ElasticsearchIndexNodeContributor previous = this.templates.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaFieldTemplateNameConflict(name, this.eventContext());
        }
    }

    private void putNamedPredicate(String name, ElasticsearchIndexNamedPredicateOptions options) {
        ElasticsearchIndexNamedPredicateOptions previous = this.namedPredicates.putIfAbsent(name, options);
        if (previous != null) {
            throw log.indexSchemaNamedPredicateNameConflict(name, this.eventContext());
        }
    }
}

