/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.highlighter.impl.ElasticsearchSearchHighlighter;
import org.hibernate.search.backend.elasticsearch.search.highlighter.impl.ElasticsearchSearchHighlighterImpl;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.FieldProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestRootContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchSearchQueryRequestContext
implements ProjectionRequestRootContext,
AggregationRequestContext {
    private Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContext<?> loadingContext;
    private final PredicateRequestContext rootPredicateContext;
    private final Map<DistanceSortKey, Integer> distanceSorts;
    private final Map<String, ElasticsearchSearchHighlighter> namedHighlighters;
    private final ElasticsearchSearchHighlighter queryHighlighter;

    ElasticsearchSearchQueryRequestContext(ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContext<?> loadingContext, PredicateRequestContext rootPredicateContext, Map<DistanceSortKey, Integer> distanceSorts, Map<String, ElasticsearchSearchHighlighter> namedHighlighters, ElasticsearchSearchHighlighter queryHighlighter) {
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.rootPredicateContext = rootPredicateContext;
        this.distanceSorts = distanceSorts != null ? Collections.unmodifiableMap(distanceSorts) : null;
        this.namedHighlighters = namedHighlighters;
        this.queryHighlighter = queryHighlighter;
    }

    @Override
    public PredicateRequestContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public Integer getDistanceSortIndex(String absoluteFieldPath, GeoPoint location) {
        if (this.distanceSorts == null) {
            return null;
        }
        return this.distanceSorts.get(new DistanceSortKey(absoluteFieldPath, location));
    }

    @Override
    public ElasticsearchSearchSyntax getSearchSyntax() {
        return this.scope.searchSyntax();
    }

    @Override
    public void checkValidField(String absoluteFieldPath) {
    }

    @Override
    public void checkNotNested(SearchQueryElementTypeKey<?> projectionKey, String hint) {
    }

    @Override
    public ProjectionRequestRootContext root() {
        return this;
    }

    @Override
    public ProjectionRequestContext forField(String absoluteFieldPath, String[] absoluteFieldPathComponents) {
        return new FieldProjectionRequestContext(this, absoluteFieldPath, absoluteFieldPathComponents);
    }

    @Override
    public String absoluteCurrentFieldPath() {
        return null;
    }

    @Override
    public String[] relativeCurrentFieldPathComponents() {
        return null;
    }

    @Override
    public ElasticsearchSearchHighlighter highlighter(String highlighterName) {
        if (highlighterName == null) {
            return ElasticsearchSearchHighlighterImpl.NO_OPTIONS_CONFIGURATION;
        }
        ElasticsearchSearchHighlighter highlighter = this.namedHighlighters.get(highlighterName);
        if (highlighter == null) {
            throw this.log.cannotFindHighlighter(highlighterName, this.namedHighlighters.keySet());
        }
        return highlighter;
    }

    @Override
    public ElasticsearchSearchHighlighter queryHighlighter() {
        return this.queryHighlighter;
    }

    ElasticsearchSearchQueryExtractContext createExtractContext(JsonObject responseBody) {
        return new ElasticsearchSearchQueryExtractContext(this, this.sessionContext, this.loadingContext.createProjectionHitMapper(), responseBody);
    }
}

