package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import java.lang.String;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.backend.types.TermVector;
import org.jboss.logging.Logger;
import java.lang.Number;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.apache.http.HttpHost;
import org.jboss.logging.BasicLogger;
import java.util.List;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import java.util.regex.Pattern;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import javax.annotation.processing.Generated;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import java.time.Duration;
import java.io.IOException;
import org.hibernate.search.util.common.data.Range;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.util.common.SearchTimeoutException;
import com.google.gson.JsonElement;
import org.hibernate.search.engine.search.projection.SearchProjection;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.search.engine.search.sort.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2023-12-05T12:01:58+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchRequestFailed(final ElasticsearchRequest request, final ElasticsearchResponse response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }
    @Override
    public final SearchException elasticsearchBulkedRequestFailed(final JsonObject requestMetadata, final JsonObject response, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchStatus408RequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch response indicates a timeout (HTTP status 408)";
    }
    @Override
    public final SearchException elasticsearchStatus408RequestTimeout() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchStatus408RequestTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchMappingUpdateFailed$str() {
        return "HSEARCH400020: Unable to update mapping for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchMappingUpdateFailed(final String indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchMappingUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexStatus(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$sms.";
    }
    @Override
    public final SearchException unexpectedIndexStatus(final URLEncodedString indexName, final String expected, final int requiredStatusTimeoutInMs, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedIndexStatus$str(), indexName, expected, requiredStatusTimeoutInMs), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Unable to retrieve index metadata from Elasticsearch: %1$s";
    }
    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexMetadataRetrievalFailed$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Unable to update schema for index '%1$s': %2$s";
    }
    @Override
    public final SearchException schemaUpdateFailed(final URLEncodedString indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexMissing$str() {
        return "HSEARCH400050: Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }
    @Override
    public final SearchException indexMissing(final URLEncodedString write, final URLEncodedString read) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexMissing$str(), write, read));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executingElasticsearchQuery(final String path, final Map<String, String> parameters, final String bodyParts) {
        super.log.logf(FQCN, TRACE, null, executingElasticsearchQuery$str(), path, parameters, bodyParts);
    }
    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }
    protected String tokenizerNamingConflict$str() {
        return "HSEARCH400055: Duplicate tokenizer definitions: '%1$s'. Tokenizer names must be unique.";
    }
    @Override
    public final SearchException tokenizerNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenizerNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String charFilterNamingConflict$str() {
        return "HSEARCH400056: Duplicate char filter definitions: '%1$s'. Char filter names must be unique.";
    }
    @Override
    public final SearchException charFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), charFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tokenFilterNamingConflict$str() {
        return "HSEARCH400057: Duplicate token filter definitions: '%1$s'. Token filter names must be unique.";
    }
    @Override
    public final SearchException tokenFilterNamingConflict(final String remoteName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tokenFilterNamingConflict$str(), remoteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Unable to update settings for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(final Object indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchSettingsUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void closedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, closedIndex$str(), indexName);
    }
    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void openedIndex(final Object indexName) {
        super.log.logf(FQCN, INFO, null, openedIndex$str(), indexName);
    }
    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }
    @Override
    public final void usingPasswordOverHttp() {
        super.log.logf(FQCN, WARN, null, usingPasswordOverHttp$str());
    }
    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH400075: Unable to apply analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e, eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    }
    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenizerDefinition$str() {
        return "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenizerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchCharFilterDefinition$str() {
        return "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchCharFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    }
    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTokenFilterDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToDetectElasticsearchVersion$str() {
        return "HSEARCH400080: Unable to detect the Elasticsearch version running on the cluster: %s";
    }
    @Override
    public final SearchException failedToDetectElasticsearchVersion(final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToDetectElasticsearchVersion$str(), causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedElasticsearchVersion$str() {
        return "HSEARCH400081: Incompatible Elasticsearch version: '%s'. Refer to the documentation to know which versions of Elasticsearch are compatible with Hibernate Search.";
    }
    @Override
    public final SearchException unsupportedElasticsearchVersion(final ElasticsearchVersion version) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedElasticsearchVersion$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executedRequestWithFailure(final String method, final HttpHost host, final String path, final Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage, final String requestBodyParts, final String responseBody) {
        super.log.logf(FQCN, DEBUG, null, executedRequestWithFailure$str(), method, host, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody);
    }
    protected String executedRequestWithFailure$str() {
        return "HSEARCH400082: Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }
    @Override
    public final void unknownElasticsearchVersion(final ElasticsearchVersion version) {
        super.log.logf(FQCN, WARN, null, unknownElasticsearchVersion$str(), version);
    }
    protected String unknownElasticsearchVersion$str() {
        return "HSEARCH400085: Unknown Elasticsearch version running on the cluster: '%s'. Hibernate Search may not work correctly. Consider updating to a newer version of Hibernate Search, if any.";
    }
    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s";
    }
    @Override
    public final SearchException failedToParseElasticsearchResponse(final int statusCode, final String statusPhrase, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToParseElasticsearchResponse$str(), statusCode, statusPhrase, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }
    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseIndicatesFailure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executedRequest(final String method, final HttpHost host, final String path, final Map<String, String> getParameters, final int bodyParts, final long timeInMs, final int responseStatusCode, final String responseStatusMessage, final String requestBodyParts, final String responseBody) {
        super.log.logf(FQCN, TRACE, null, executedRequest$str(), method, host, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody);
    }
    protected String executedRequest$str() {
        return "HSEARCH400093: Executed Elasticsearch HTTP %s request to '%s' with path '%s', query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }
    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager elasticsearchIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.";
    }
    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final Set<String> tenantIds, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantIds), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientUnwrappingWithUnkownType$str() {
        return "HSEARCH400518: Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException clientUnwrappingWithUnkownType(final Class<?> requestedClass, final Class<?> actualClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), clientUnwrappingWithUnkownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.";
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Missing data in the Elasticsearch response.";
    }
    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        final AssertionFailure result = new AssertionFailure(String.format(getLoggingLocale(), elasticsearchResponseMissingData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ceiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ceiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'";
    }
    @Override
    public final SearchException conflictingIndexNames(final String firstHibernateSearchIndexName, final String secondHibernateSearchIndexName, final String nameOrAlias) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Unable to resolve index name '%1$s' to an entity type: %2$s";
    }
    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(final String elasticsearchIndexName, final String causeMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH400532: Unable to convert DSL argument: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    }
    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH400535: Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH400536: Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH400537: Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final JsonElement value1, final JsonElement value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToShutdownClient$str() {
        return "HSEARCH400544: Unable to shut down the Elasticsearch client: %1$s";
    }
    @Override
    public final SearchException unableToShutdownClient(final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToShutdownClient$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: No built-in index field type for class: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Full-text features (analysis, fuzziness) are not supported for fields of this type.";
    }
    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fullTextFeaturesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchVersionWithoutDistribution$str() {
        return "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.";
    }
    @Override
    public final SearchException invalidElasticsearchVersionWithoutDistribution(final String invalidRepresentation, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchVersionWithoutDistribution$str(), invalidRepresentation), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchVersionWithOptionalDistribution$str() {
        return "HSEARCH400557: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier' or '<distribution>:x.y.z-qualifier' or just '<distribution>', where '<distribution>' is one of %2$s (defaults to '%3$s'), 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example 'elastic:7.0', '7.0' or just '7'. Note that the format '<distribution>' without a version number is only useful for distributions that don't support version numbers, such as Amazon OpenSearch Serverless.";
    }
    @Override
    public final SearchException invalidElasticsearchVersionWithOptionalDistribution(final String invalidRepresentation, final List<String> validDistributions, final String defaultDistribution, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchVersionWithOptionalDistribution$str(), invalidRepresentation, validDistributions, defaultDistribution), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidElasticsearchDistributionName$str() {
        return "HSEARCH400558: Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidElasticsearchDistributionName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidElasticsearchDistributionName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedElasticsearchVersion$str() {
        return "HSEARCH400559: Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.";
    }
    @Override
    public final SearchException unexpectedElasticsearchVersion(final ElasticsearchVersion configuredVersion, final ElasticsearchVersion actualVersion) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedElasticsearchVersion$str(), configuredVersion, actualVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String skipAnalysisOnNormalizedField$str() {
        return "HSEARCH400560: Cannot skip analysis on field '%1$s': the Elasticsearch backend will always normalize arguments before attempting matches on normalized fields.";
    }
    @Override
    public final SearchException skipAnalysisOnNormalizedField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), skipAnalysisOnNormalizedField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH400562: Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH400563: Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeName$str() {
        return "HSEARCH400564: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }
    @Override
    public final SearchException explainRequiresTypeName(final Set<String> targetedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeName$str(), targetedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH400565: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Invalid document identifier: '%2$s'. No such document in index '%1$s'.";
    }
    @Override
    public final SearchException explainUnknownDocument(final URLEncodedString indexName, final URLEncodedString id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnknownDocument$str(), indexName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullDecimalScale$str() {
        return "HSEARCH400567: Invalid index field type: missing decimal scale. Define the decimal scale explicitly.  %1$s";
    }
    @Override
    public final SearchException nullDecimalScale(final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullDecimalScale$str(), hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH400569: Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value, final Number min, final Number max) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value, min, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.";
    }
    @Override
    public final SearchException invalidDecimalScale(final Integer decimalScale, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDecimalScale$str(), decimalScale), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s, but the given predicate was built from a scope targeting indexes %2$s.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s, but the given sort was built from a scope targeting indexes %2$s.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort sort, final Set<String> sortIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s, but the given projection was built from a scope targeting indexes %2$s.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> projection, final Set<String> projectionIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH400576: Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.";
    }
    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(final Range<?> range) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s, but the given aggregation was built from a scope targeting indexes %2$s.";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Duplicate aggregation definitions for key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH400587: Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: Call to the bulk REST API failed: %1$s";
    }
    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchFailedBecauseOfBulkFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }
    @Override
    public final SearchException invalidHostAndPort(final String hostAndPort, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidHostAndPort$str(), hostAndPort), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestTimedOut$str() {
        return "HSEARCH400590: Request execution exceeded the timeout of %1$s. Request was %2$s";
    }
    @Override
    public final SearchTimeoutException requestTimedOut(final Duration timeout, final ElasticsearchRequest request) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), requestTimedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidTypeNameMappingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException missingTypeFieldInDocument(final String fieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingTypeFieldInDocument$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.";
    }
    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(final URLEncodedString write, final URLEncodedString read, final Set<String> matchingIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.";
    }
    @Override
    public final SearchException invalidIndexPrimaryName(final String elasticsearchIndexName, final Pattern pattern) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.";
    }
    @Override
    public final SearchException invalidIndexUniqueKey(final String uniqueKey, final Set<String> knownKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.";
    }
    @Override
    public final SearchException sameWriteAndReadAliases(final URLEncodedString writeAndReadAlias, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sameWriteAndReadAliases$str(), writeAndReadAlias), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String impreciseElasticsearchVersionWhenVersionCheckDisabled$str() {
        return "HSEARCH400597: Missing or imprecise Elasticsearch version: configuration property '%1$s' is set to 'false', so you must set the version explicitly with at least as much precision as 'x.y', where 'x' and 'y' are integers.";
    }
    @Override
    public final SearchException impreciseElasticsearchVersionWhenVersionCheckDisabled(final String versionCheckPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), impreciseElasticsearchVersionWhenVersionCheckDisabled$str(), versionCheckPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lifecycleStrategyMovedToMapper$str() {
        return "HSEARCH400598: The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.";
    }
    @Override
    public final SearchException lifecycleStrategyMovedToMapper() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), lifecycleStrategyMovedToMapper$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH400600: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }
    @Override
    public final SearchException invalidSortModeAcrossNested(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeAcrossNested$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForStringField$str() {
        return "HSEARCH400601: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }
    @Override
    public final SearchException invalidSortModeForStringField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForStringField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH400602: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForTemporalField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForTemporalField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH400603: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForDistanceSort(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForDistanceSort$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH400604: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH400605: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final SearchPredicate predicate, final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH400606: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH400607: Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaFieldTemplateNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH400608: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH400609: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH400613: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.multi()' when you create the projection.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(final String absolutePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH400617: Implementation class differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentImplementationClassForQueryElement(final Class<?> class1, final Class<?> class2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentImplementationClassForQueryElement$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class1), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH400618: Field codec differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentFieldCodecForQueryElement(final Object codec1, final Object codec2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentFieldCodecForQueryElement$str(), codec1, codec2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDynamicType$str() {
        return "HSEARCH400621: Invalid dynamic type: '%1$s'. Valid values are: %2$s.";
    }
    @Override
    public final SearchException invalidDynamicType(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDynamicType$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchAliasUpdateFailed$str() {
        return "HSEARCH400625: Unable to update aliases for index '%1$s': %2$s";
    }
    @Override
    public final SearchException elasticsearchAliasUpdateFailed(final Object indexName, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchAliasUpdateFailed$str(), indexName, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uriAndProtocol$str() {
        return "HSEARCH400626: Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }
    @Override
    public final SearchException uriAndProtocol(final List<String> uris, final String protocol) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uriAndProtocol$str(), uris, protocol));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uriAndHosts$str() {
        return "HSEARCH400627: Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }
    @Override
    public final SearchException uriAndHosts(final List<String> uris, final List<String> hosts) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uriAndHosts$str(), uris, hosts));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentProtocolsOnUris$str() {
        return "HSEARCH400628: Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.";
    }
    @Override
    public final SearchException differentProtocolsOnUris(final List<String> uris) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentProtocolsOnUris$str(), uris));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyListOfHosts$str() {
        return "HSEARCH400629: Invalid target hosts configuration: the list of hosts must not be empty.";
    }
    @Override
    public final SearchException emptyListOfHosts() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), emptyListOfHosts$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyListOfUris$str() {
        return "HSEARCH400630: Invalid target hosts configuration: the list of URIs must not be empty.";
    }
    @Override
    public final SearchException emptyListOfUris() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), emptyListOfUris$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsFileNotFound$str() {
        return "HSEARCH400631: Unable to find the given custom index settings file: '%1$s'.";
    }
    @Override
    public final SearchException customIndexSettingsFileNotFound(final String filePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsFileNotFound$str(), filePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsErrorOnLoading$str() {
        return "HSEARCH400632: Error on loading the given custom index settings file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexSettingsErrorOnLoading(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsErrorOnLoading$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexSettingsJsonSyntaxErrors$str() {
        return "HSEARCH400633: There are some JSON syntax errors on the given custom index settings file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexSettingsJsonSyntaxErrors(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexSettingsJsonSyntaxErrors$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingFirstOnAscSortNotSupported$str() {
        return "HSEARCH400634: Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingFirstOnAscSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFirstOnAscSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLastOnDescSortNotSupported$str() {
        return "HSEARCH400635: Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingLastOnDescSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLastOnDescSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingAsOnSortNotSupported$str() {
        return "HSEARCH400636: Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingAsOnSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingAsOnSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNamedPredicateNameConflict$str() {
        return "HSEARCH400637: The index schema named predicate '%1$s' was added twice.";
    }
    @Override
    public final SearchException indexSchemaNamedPredicateNameConflict(final String relativeFilterName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNamedPredicateNameConflict$str(), relativeFilterName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH400638: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(final Object predicateDefinition1, final Object predicateDefinition2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void defaultedLimitedHits(final Integer defaultLimit, final long hitCount) {
        super.log.logf(FQCN, WARN, null, defaultedLimitedHits$str(), defaultLimit, hitCount);
    }
    protected String defaultedLimitedHits$str() {
        return "HSEARCH400640: A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.";
    }
    protected String incompatibleElasticsearchVersionOnStart$str() {
        return "HSEARCH400641: Incompatible Elasticsearch version: version '%2$s' does not match version '%1$s' that was provided when the backend was created. You can provide a more precise version on startup, but you cannot override the version that was provided when the backend was created.";
    }
    @Override
    public final SearchException incompatibleElasticsearchVersionOnStart(final ElasticsearchVersion versionOnCreation, final ElasticsearchVersion versionOnStart) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompatibleElasticsearchVersionOnStart$str(), versionOnCreation, versionOnStart));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH400648: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButExplicitlyDisabledByBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH400649: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }
    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramNotDefined$str() {
        return "HSEARCH400650: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }
    @Override
    public final SearchException paramNotDefined(final String name, final String predicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), paramNotDefined$str(), name, predicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingFileNotFound$str() {
        return "HSEARCH400651: Unable to find the given custom index mapping file: '%1$s'.";
    }
    @Override
    public final SearchException customIndexMappingFileNotFound(final String filePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingFileNotFound$str(), filePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingErrorOnLoading$str() {
        return "HSEARCH400652: Error on loading the given custom index mapping file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexMappingErrorOnLoading(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingErrorOnLoading$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customIndexMappingJsonSyntaxErrors$str() {
        return "HSEARCH400653: There are some JSON syntax errors on the given custom index mapping file '%1$s': %2$s";
    }
    @Override
    public final SearchException customIndexMappingJsonSyntaxErrors(final String filePath, final String causeMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), customIndexMappingJsonSyntaxErrors$str(), filePath, causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH400654: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }
    @Override
    public final SearchException invalidContextForProjectionOnField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH400655: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.multi()' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).multi()'.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH400656: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(final String typeName, final Set<String> expectedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToExportSchema$str() {
        return "HSEARCH400657: Unable to export the schema for '%1$s' index: %2$s";
    }
    @Override
    public final SearchException unableToExportSchema(final String indexName, final String message, final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToExportSchema$str(), indexName, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLowestOnAscSortNotSupported$str() {
        return "HSEARCH400658: Invalid use of 'missing().lowest()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }
    @Override
    public final SearchException missingLowestOnAscSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLowestOnAscSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLowestOnDescSortNotSupported$str() {
        return "HSEARCH400659: Invalid use of 'missing().lowest()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }
    @Override
    public final SearchException missingLowestOnDescSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLowestOnDescSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH400660: Invalid highlighter: '%1$s'. You must build the highlighter from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(final SearchHighlighter highlighter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH400661: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s, but the given highlighter was built from a scope targeting indexes %2$s.";
    }
    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(final SearchHighlighter highlighter, final Set<String> configurationIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, configurationIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noFieldsToHighlight() {
        super.log.logf(FQCN, WARN, null, noFieldsToHighlight$str());
    }
    protected String noFieldsToHighlight$str() {
        return "HSEARCH400662: No fields were added to be highlighted, but some query level highlighters were provided. These highlighters will be ignored.";
    }
    protected String cannotFindHighlighter$str() {
        return "HSEARCH400663: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }
    @Override
    public final SearchException cannotFindHighlighter(final String highlighterName, final Set<String> highlighters) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindHighlighter$str(), highlighterName, highlighters));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH400664: Named highlighters cannot use a blank string as name.";
    }
    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterNameCannotBeBlank$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH400665: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }
    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(final String highlighterName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH400666: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }
    @Override
    public final SearchException highlighterTypeNotSupported(final SearchHighlighterType type, final String field) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterTypeNotSupported$str(), type, field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedMixOfHighlightableValues$str() {
        return "HSEARCH400667: Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'";
    }
    @Override
    public final SearchException unsupportedMixOfHighlightableValues(final Set<org.hibernate.search.engine.backend.types.Highlightable> highlightable) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedMixOfHighlightableValues$str(), highlightable));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String termVectorDontAllowFastVectorHighlighter$str() {
        return "HSEARCH400668: The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.";
    }
    @Override
    public final SearchException termVectorDontAllowFastVectorHighlighter(final TermVector termVector) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), termVectorDontAllowFastVectorHighlighter$str(), termVector));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noHighlightableProvided$str() {
        return "HSEARCH400669: Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.";
    }
    @Override
    public final SearchException noHighlightableProvided() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noHighlightableProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH400670: Highlight projection cannot be applied within nested context of '%1$s'.";
    }
    @Override
    public final SearchException cannotHighlightInNestedContext(final String currentNestingField, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH400671: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }
    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightFieldFromNestedObjectStructure$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH400672: '%1$s' cannot be nested in an object projection. %2$s";
    }
    @Override
    public final SearchException cannotUseProjectionInNestedContext(final String projection, final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFetchElasticsearchVersion$str() {
        return "HSEARCH400673: The targeted Elasticsearch cluster is reachable, but does not expose its version. Check that the configured Elasticsearch hosts/URI points to the right server. If you are targeting Amazon OpenSearch Serverless, you must set the configuration property '%1$s' explicitly to '%2$s'. See the reference documentation for more information.";
    }
    @Override
    public final SearchException unableToFetchElasticsearchVersion(final String versionConfigPropertyKey, final ElasticsearchVersion expectedAWSOpenSearchServerlessVersion) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFetchElasticsearchVersion$str(), versionConfigPropertyKey, expectedAWSOpenSearchServerlessVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCheckElasticsearchVersion$str() {
        return "HSEARCH400674: Cannot check the Elasticsearch version because the targeted Elasticsearch distribution '%s' does not expose its version.";
    }
    @Override
    public final SearchException cannotCheckElasticsearchVersion(final ElasticsearchDistributionName distributionName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCheckElasticsearchVersion$str(), distributionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedAwsOpenSearchServerlessVersion$str() {
        return "HSEARCH400675: Unexpected Amazon OpenSearch Serverless version: '%1$s'. Amazon OpenSearch Serverless doesn't use version numbers. Set the version to simply '%2$s'.";
    }
    @Override
    public final SearchException unexpectedAwsOpenSearchServerlessVersion(final ElasticsearchVersion configuredVersion, final ElasticsearchVersion expectedAWSOpenSearchServerlessVersion) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedAwsOpenSearchServerlessVersion$str(), configuredVersion, expectedAWSOpenSearchServerlessVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotExecuteOperationOnAmazonOpenSearchServerless$str() {
        return "HSEARCH400676: Cannot execute '%s' because Amazon OpenSearch Serverless does not support this operation. Either avoid this operation or switch to another Elasticsearch/OpenSearch distribution.";
    }
    @Override
    public final SearchException cannotExecuteOperationOnAmazonOpenSearchServerless(final String operation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotExecuteOperationOnAmazonOpenSearchServerless$str(), operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRequireIndexStatus$str() {
        return "HSEARCH400677: The targeted Elasticsearch cluster does not expose index status, so index status requirements cannot be enforced.";
    }
    @Override
    public final SearchException cannotRequireIndexStatus() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotRequireIndexStatus$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
