/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

public class PredicateNestingContext {
    private static final PredicateNestingContext ACCEPTS_KNN = new PredicateNestingContext(true);
    private static final PredicateNestingContext DOES_NOT_ACCEPT_KNN = new PredicateNestingContext(false);
    private final String nestedPath;
    private final boolean acceptsKnnClause;

    public static PredicateNestingContext acceptsKnn() {
        return ACCEPTS_KNN;
    }

    public static PredicateNestingContext doesNotAcceptKnn() {
        return DOES_NOT_ACCEPT_KNN;
    }

    public static PredicateNestingContext nested(String nestedPath) {
        return new PredicateNestingContext(nestedPath);
    }

    private PredicateNestingContext(String nestedPath, boolean acceptsKnnClause) {
        this.nestedPath = nestedPath;
        this.acceptsKnnClause = acceptsKnnClause;
    }

    private PredicateNestingContext(String nestedPath) {
        this(nestedPath, false);
    }

    private PredicateNestingContext(boolean acceptsKnnClause) {
        this(null, acceptsKnnClause);
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public boolean acceptsKnnClause() {
        return this.acceptsKnnClause;
    }

    public PredicateNestingContext rejectKnn() {
        if (!this.acceptsKnnClause) {
            return this;
        }
        if (this.nestedPath == null) {
            return DOES_NOT_ACCEPT_KNN;
        }
        return new PredicateNestingContext(this.nestedPath, false);
    }
}

