/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;

public class PredicateRequestContext {
    private final BackendSessionContext sessionContext;
    private final String nestedPath;
    private JsonElement jsonKnn = JsonNull.INSTANCE;

    public PredicateRequestContext(BackendSessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.nestedPath = null;
    }

    private PredicateRequestContext(BackendSessionContext sessionContext, String nestedPath) {
        this.sessionContext = sessionContext;
        this.nestedPath = nestedPath;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    String getTenantId() {
        return this.sessionContext.tenantIdentifier();
    }

    public PredicateRequestContext withNestedPath(String path) {
        return new PredicateRequestContext(this.sessionContext, path);
    }

    public void contributeKnnClause(JsonObject knn) {
        if (this.jsonKnn.isJsonNull()) {
            this.jsonKnn = knn;
        } else if (this.jsonKnn.isJsonArray()) {
            this.jsonKnn.getAsJsonArray().add((JsonElement)knn);
        } else {
            JsonArray array = new JsonArray();
            array.add(this.jsonKnn);
            array.add((JsonElement)knn);
            this.jsonKnn = array;
        }
    }

    public JsonElement knnSearch(JsonArray filters) {
        if (this.jsonKnn.isJsonNull()) {
            return this.jsonKnn;
        }
        return PredicateRequestContext.addFiltersToKnn(this.jsonKnn, filters);
    }

    private static JsonElement addFiltersToKnn(JsonElement jsonKnn, JsonArray filters) {
        if (filters == null || filters.isEmpty()) {
            return jsonKnn;
        }
        if (jsonKnn.isJsonArray()) {
            for (JsonElement jsonElement : jsonKnn.getAsJsonArray()) {
                PredicateRequestContext.addFiltersToKnn(jsonElement.getAsJsonObject(), filters);
            }
        } else {
            PredicateRequestContext.addFiltersToKnn(jsonKnn.getAsJsonObject(), filters);
        }
        return jsonKnn;
    }

    private static void addFiltersToKnn(JsonObject jsonKnn, JsonArray filters) {
        JsonObjectAccessor filterAccessor = JsonAccessor.root().property("filter").asObject();
        if (filters.size() == 1 && filterAccessor.get(jsonKnn).isEmpty()) {
            filterAccessor.set(jsonKnn, filters.get(0).getAsJsonObject());
        } else {
            filterAccessor.set(jsonKnn, Queries.boolFilter(filterAccessor.getOrCreate(jsonKnn, Queries::matchAll), filters));
        }
    }
}

