/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.highlighter.impl.ElasticsearchSearchHighlighter;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryRequestContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryBuilder<H>
implements SearchQueryBuilder<H>,
ElasticsearchSearchSortCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source");
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final PredicateRequestContext rootPredicateContext;
    private final SearchLoadingContextBuilder<?, ?> loadingContextBuilder;
    private final ElasticsearchSearchProjection<H> rootProjection;
    private final Integer scrollTimeout;
    private final Set<String> routingKeys;
    private JsonObject jsonPredicate;
    private JsonArray jsonSort;
    private Map<DistanceSortKey, Integer> distanceSorts;
    private Map<AggregationKey<?>, ElasticsearchSearchAggregation<?>> aggregations;
    private Long timeoutValue;
    private TimeUnit timeoutUnit;
    private boolean exceptionOnTimeout;
    private Long totalHitCountThreshold;
    private ElasticsearchSearchHighlighter queryHighlighter;
    private final Map<String, ElasticsearchSearchHighlighter> namedHighlighters = new HashMap<String, ElasticsearchSearchHighlighter>();
    private ElasticsearchSearchRequestTransformer requestTransformer;

    public ElasticsearchSearchQueryBuilder(ElasticsearchWorkFactory workFactory, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<H> rootProjection, Integer scrollTimeout) {
        this.workFactory = workFactory;
        this.searchResultExtractorFactory = searchResultExtractorFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.rootPredicateContext = new PredicateRequestContext(sessionContext);
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
        this.scrollTimeout = scrollTimeout;
    }

    public void predicate(SearchPredicate predicate) {
        ElasticsearchSearchPredicate elasticsearchPredicate = ElasticsearchSearchPredicate.from(this.scope, predicate);
        this.jsonPredicate = elasticsearchPredicate.toJsonQuery(this.rootPredicateContext);
    }

    public void sort(SearchSort sort) {
        ElasticsearchSearchSort elasticsearchSort = ElasticsearchSearchSort.from(this.scope, sort);
        elasticsearchSort.toJsonSorts(this);
    }

    public <A> void aggregation(AggregationKey<A> key, SearchAggregation<A> aggregation) {
        ElasticsearchSearchAggregation previous;
        if (!(aggregation instanceof ElasticsearchSearchAggregation)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherAggregations(aggregation);
        }
        ElasticsearchSearchAggregation casted = (ElasticsearchSearchAggregation)aggregation;
        if (!this.scope.hibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.getIndexNames(), this.scope.hibernateSearchIndexNames());
        }
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, casted)) != null) {
            throw log.duplicateAggregationKey(key);
        }
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    public void totalHitCountThreshold(long totalHitCountThreshold) {
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public void highlighter(SearchHighlighter queryHighlighter) {
        this.queryHighlighter = ElasticsearchSearchHighlighter.from(this.scope, queryHighlighter);
    }

    public void highlighter(String highlighterName, SearchHighlighter highlighter) {
        if (highlighterName == null || highlighterName.trim().isEmpty()) {
            throw log.highlighterNameCannotBeBlank();
        }
        if (this.namedHighlighters.put(highlighterName, ElasticsearchSearchHighlighter.from(this.scope, highlighter)) != null) {
            throw log.highlighterWithTheSameNameCannotBeAdded(highlighterName);
        }
    }

    @Override
    public PredicateRequestContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public void collectSort(JsonElement sort) {
        if (this.jsonSort == null) {
            this.jsonSort = new JsonArray();
        }
        this.jsonSort.add(sort);
    }

    @Override
    public void collectDistanceSort(JsonElement sort, String absoluteFieldPath, GeoPoint center) {
        this.collectSort(sort);
        int index = this.jsonSort.size() - 1;
        if (this.distanceSorts == null) {
            this.distanceSorts = CollectionHelper.newHashMap((int)3);
        }
        this.distanceSorts.put(new DistanceSortKey(absoluteFieldPath, center), index);
    }

    public void requestTransformer(ElasticsearchSearchRequestTransformer transformer) {
        Contracts.assertNotNull((Object)transformer, (String)"transformer");
        this.requestTransformer = transformer;
    }

    public ElasticsearchSearchQuery<H> build() {
        JsonObject jsonQuery;
        JsonElement jsonKnn;
        JsonObject payload = new JsonObject();
        JsonArray filters = new JsonArray();
        JsonObject filter = this.scope.filterOrNull(this.sessionContext.tenantIdentifier());
        if (filter != null) {
            filters.add((JsonElement)filter);
        }
        if (!this.routingKeys.isEmpty()) {
            filters.add((JsonElement)Queries.anyTerm("_routing", this.routingKeys));
        }
        if (!(jsonKnn = this.rootPredicateContext.knnSearch(filters)).isJsonNull()) {
            payload.add("knn", jsonKnn);
        }
        if ((jsonKnn.isJsonNull() || this.jsonPredicate != null) && (jsonQuery = Queries.boolFilter(this.jsonPredicate, filters)) != null) {
            payload.add("query", (JsonElement)jsonQuery);
        }
        if (this.jsonSort != null) {
            payload.add("sort", (JsonElement)this.jsonSort);
        }
        SearchLoadingContext loadingContext = this.loadingContextBuilder.build();
        ElasticsearchSearchQueryRequestContext requestContext = new ElasticsearchSearchQueryRequestContext(this.scope, this.sessionContext, loadingContext, this.rootPredicateContext, this.distanceSorts, this.namedHighlighters, this.queryHighlighter);
        ElasticsearchSearchProjection.Extractor<?, H> rootExtractor = this.rootProjection.request(payload, requestContext);
        if (this.aggregations != null) {
            JsonObject jsonAggregations = new JsonObject();
            for (Map.Entry<AggregationKey<?>, ElasticsearchSearchAggregation<?>> entry : this.aggregations.entrySet()) {
                jsonAggregations.add(entry.getKey().name(), (JsonElement)entry.getValue().request(requestContext));
            }
            payload.add("aggregations", (JsonElement)jsonAggregations);
        }
        if (this.queryHighlighter != null) {
            this.queryHighlighter.request(payload);
        }
        if (!REQUEST_SOURCE_ACCESSOR.get(payload).isPresent()) {
            REQUEST_SOURCE_ACCESSOR.set(payload, (JsonElement)new JsonPrimitive(Boolean.FALSE));
        }
        TimeoutManager timeoutManager = this.scope.createTimeoutManager(this.timeoutValue, this.timeoutUnit, this.exceptionOnTimeout);
        ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor = this.searchResultExtractorFactory.createResultExtractor(requestContext, rootExtractor, this.aggregations == null ? Collections.emptyMap() : this.aggregations);
        return new ElasticsearchSearchQueryImpl<H>(this.workFactory, this.queryOrchestrator, this.scope, this.sessionContext, loadingContext, this.routingKeys, payload, this.requestTransformer, searchResultExtractor, timeoutManager, this.scrollTimeout, this.totalHitCountThreshold);
    }
}

