/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.ElasticsearchDenseVectorIndexOptions;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.OpenSearchVectorTypeMethod;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.AbstractTypeMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.JsonElementValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;
import org.hibernate.search.util.common.impl.CollectionHelper;

abstract class PropertyMappingValidator
extends AbstractTypeMappingValidator<PropertyMapping> {
    private static final List<String> DEFAULT_DATE_FORMAT;

    PropertyMappingValidator() {
    }

    @Override
    protected Validator<PropertyMapping> getPropertyMappingValidator() {
        return this;
    }

    @Override
    public void validate(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "type", expectedMapping.getType(), actualMapping.getType(), "object");
        List<String> formatDefault = "date".equals(expectedMapping.getType()) ? DEFAULT_DATE_FORMAT : Collections.emptyList();
        LeafValidators.FORMAT.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "format", expectedMapping.getFormat(), actualMapping.getFormat(), formatDefault);
        LeafValidators.EQUAL_DOUBLE.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "scaling_factor", expectedMapping.getScalingFactor(), actualMapping.getScalingFactor());
        this.validateIndexOptions(errorCollector, expectedMapping, actualMapping);
        LeafValidators.jsonElement(expectedMapping.getType()).validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "null_value", (JsonElement)expectedMapping.getNullValue(), (JsonElement)actualMapping.getNullValue());
        this.validateAnalyzerOptions(errorCollector, expectedMapping, actualMapping);
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "term_vector", expectedMapping.getTermVector(), actualMapping.getTermVector(), "no");
        this.validateVectorMapping(errorCollector, expectedMapping, actualMapping);
        super.validate(errorCollector, expectedMapping, actualMapping);
    }

    private void validateAnalyzerOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "analyzer", expectedMapping.getAnalyzer(), actualMapping.getAnalyzer(), "default");
        LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "search_analyzer", expectedMapping.getSearchAnalyzer(), actualMapping.getSearchAnalyzer(), expectedMapping.getAnalyzer() == null ? "default" : expectedMapping.getAnalyzer(), actualMapping.getAnalyzer() == null ? "default" : actualMapping.getAnalyzer());
        LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "normalizer", expectedMapping.getNormalizer(), actualMapping.getNormalizer());
    }

    private void validateIndexOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Boolean expectedDocValues;
        Boolean expectedNorms;
        Boolean expectedIndex = expectedMapping.getIndex();
        if (Boolean.TRUE.equals(expectedIndex)) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "index", expectedIndex, actualMapping.getIndex(), true);
        }
        if (Boolean.TRUE.equals(expectedNorms = expectedMapping.getNorms())) {
            Boolean normsDefault = "text".equals(expectedMapping.getType()) ? Boolean.TRUE : Boolean.FALSE;
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "norms", expectedNorms, actualMapping.getNorms(), normsDefault);
        }
        if (Boolean.TRUE.equals(expectedDocValues = expectedMapping.getDocValues())) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "doc_values", expectedDocValues, actualMapping.getDocValues(), true);
        }
    }

    protected abstract void validateVectorMapping(ValidationErrorCollector var1, PropertyMapping var2, PropertyMapping var3);

    static {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("strict_date_optional_time");
        formats.add("epoch_millis");
        DEFAULT_DATE_FORMAT = CollectionHelper.toImmutableList(formats);
    }

    static abstract class AbstractVectorAttributesValidator<T>
    implements Validator<T> {
        private final Validator<JsonElement> extraAttributeValidator = new JsonElementValidator(new JsonElementEquivalence());

        AbstractVectorAttributesValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void validate(ValidationErrorCollector errorCollector, T expected, T actual) {
            errorCollector.push(ValidationContextType.MAPPING_ATTRIBUTE, this.propertyName());
            try {
                this.doValidate(errorCollector, expected, actual);
                this.extraAttributeValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.CUSTOM_INDEX_MAPPING_ATTRIBUTE, ElasticsearchValidationMessages.INSTANCE.customIndexMappingAttributeMissing(), this.expectedMappingExtraAttributes(expected), this.actualMappingExtraAttributes(actual));
            }
            finally {
                errorCollector.pop();
            }
        }

        protected abstract String propertyName();

        protected abstract void doValidate(ValidationErrorCollector var1, T var2, T var3);

        protected abstract Map<String, JsonElement> expectedMappingExtraAttributes(T var1);

        protected abstract Map<String, JsonElement> actualMappingExtraAttributes(T var1);
    }

    private static class OpenSearchVectorTypeMethodParametersValidator
    extends AbstractVectorAttributesValidator<OpenSearchVectorTypeMethod.Parameters> {
        private OpenSearchVectorTypeMethodParametersValidator() {
        }

        @Override
        protected String propertyName() {
            return "parameters";
        }

        @Override
        public void doValidate(ValidationErrorCollector errorCollector, OpenSearchVectorTypeMethod.Parameters expected, OpenSearchVectorTypeMethod.Parameters actual) {
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "m", expected.getM(), actual.getM());
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "ef_construction", expected.getEfConstruction(), actual.getEfConstruction());
        }

        @Override
        protected Map<String, JsonElement> expectedMappingExtraAttributes(OpenSearchVectorTypeMethod.Parameters expected) {
            return expected.getExtraAttributes();
        }

        @Override
        protected Map<String, JsonElement> actualMappingExtraAttributes(OpenSearchVectorTypeMethod.Parameters actual) {
            return actual.getExtraAttributes();
        }
    }

    private static class OpenSearchVectorTypeMethodValidator
    extends AbstractVectorAttributesValidator<OpenSearchVectorTypeMethod> {
        private final OpenSearchVectorTypeMethodParametersValidator parametersValidator = new OpenSearchVectorTypeMethodParametersValidator();

        private OpenSearchVectorTypeMethodValidator() {
        }

        @Override
        protected String propertyName() {
            return "method";
        }

        @Override
        public void doValidate(ValidationErrorCollector errorCollector, OpenSearchVectorTypeMethod expected, OpenSearchVectorTypeMethod actual) {
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "name", expected.getName(), actual.getName());
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "space_type", expected.getSpaceType(), actual.getSpaceType(), "l2");
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "engine", expected.getEngine(), actual.getEngine());
            OpenSearchVectorTypeMethod.Parameters expectedParameters = expected.getParameters();
            if (expectedParameters != null) {
                this.parametersValidator.validate(errorCollector, expectedParameters, actual.getParameters());
            }
        }

        @Override
        protected Map<String, JsonElement> expectedMappingExtraAttributes(OpenSearchVectorTypeMethod expected) {
            return expected.getExtraAttributes();
        }

        @Override
        protected Map<String, JsonElement> actualMappingExtraAttributes(OpenSearchVectorTypeMethod actual) {
            return actual.getExtraAttributes();
        }
    }

    private static class ElasticsearchDenseVectorIndexOptionsValidator
    extends AbstractVectorAttributesValidator<ElasticsearchDenseVectorIndexOptions> {
        private ElasticsearchDenseVectorIndexOptionsValidator() {
        }

        @Override
        protected String propertyName() {
            return "index_options";
        }

        @Override
        public void doValidate(ValidationErrorCollector errorCollector, ElasticsearchDenseVectorIndexOptions expected, ElasticsearchDenseVectorIndexOptions actual) {
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "type", expected.getType(), actual.getType());
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "m", expected.getM(), actual.getM(), 16);
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "ef_construction", expected.getEfConstruction(), actual.getEfConstruction(), 100);
        }

        @Override
        protected Map<String, JsonElement> expectedMappingExtraAttributes(ElasticsearchDenseVectorIndexOptions expected) {
            return expected.getExtraAttributes();
        }

        @Override
        protected Map<String, JsonElement> actualMappingExtraAttributes(ElasticsearchDenseVectorIndexOptions actual) {
            return actual.getExtraAttributes();
        }
    }

    static class OpenSearch2PropertyMappingValidator
    extends PropertyMappingValidator {
        private final OpenSearchVectorTypeMethodValidator methodValidator = new OpenSearchVectorTypeMethodValidator();

        OpenSearch2PropertyMappingValidator() {
        }

        @Override
        protected void validateVectorMapping(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "dimension", expectedMapping.getDimension(), actualMapping.getDimension());
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "data_type", expectedMapping.getDataType(), actualMapping.getDataType());
            OpenSearchVectorTypeMethod expectedMethod = expectedMapping.getMethod();
            if (expectedMethod != null) {
                this.methodValidator.validate(errorCollector, expectedMethod, actualMapping.getMethod());
            }
        }
    }

    static class OpenSearch1PropertyMappingValidator
    extends PropertyMappingValidator {
        OpenSearch1PropertyMappingValidator() {
        }

        @Override
        protected void validateVectorMapping(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        }
    }

    static class Elasticsearch8PropertyMappingValidator
    extends PropertyMappingValidator {
        private final ElasticsearchDenseVectorIndexOptionsValidator indexOptionsValidator = new ElasticsearchDenseVectorIndexOptionsValidator();

        Elasticsearch8PropertyMappingValidator() {
        }

        @Override
        protected void validateVectorMapping(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "element_type", expectedMapping.getElementType(), actualMapping.getElementType(), "float");
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "dims", expectedMapping.getDims(), actualMapping.getDims());
            LeafValidators.EQUAL.validateWithDefault(errorCollector, ValidationContextType.MAPPING_ATTRIBUTE, "similarity", expectedMapping.getSimilarity(), actualMapping.getSimilarity(), "cosine");
            ElasticsearchDenseVectorIndexOptions indexOptions = expectedMapping.getIndexOptions();
            if (indexOptions != null) {
                this.indexOptionsValidator.validate(errorCollector, indexOptions, actualMapping.getIndexOptions());
            }
        }
    }

    static class Elasticsearch7PropertyMappingValidator
    extends PropertyMappingValidator {
        Elasticsearch7PropertyMappingValidator() {
        }

        @Override
        protected void validateVectorMapping(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        }
    }
}

