/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedPredicateDefinitionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchNamedPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSearchPredicate providedPredicate;

    private ElasticsearchNamedPredicate(Builder builder, ElasticsearchSearchPredicate providedPredicate) {
        super(builder);
        this.providedPredicate = providedPredicate;
    }

    @Override
    public void checkNestableWithin(PredicateNestingContext context) {
        this.providedPredicate.checkNestableWithin(context);
        super.checkNestableWithin(context);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        return this.providedPredicate.toJsonQuery(context);
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        private final PredicateDefinition definition;
        private final String predicateName;
        private final ElasticsearchSearchIndexCompositeNodeContext field;
        private SearchPredicateFactory factory;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(PredicateDefinition definition, String predicateName, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.definition = definition;
            this.predicateName = predicateName;
            this.field = node;
        }

        public void factory(SearchPredicateFactory factory) {
            this.factory = factory;
        }

        public void param(String name, Object value) {
            this.params.put(name, value);
        }

        public SearchPredicate build() {
            NamedValuesBasedPredicateDefinitionContext ctx = new NamedValuesBasedPredicateDefinitionContext(this.factory, this.params, name -> log.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            ElasticsearchSearchPredicate providedPredicate = ElasticsearchSearchPredicate.from(this.scope, this.definition.create((PredicateDefinitionContext)ctx));
            return new ElasticsearchNamedPredicate(this, providedPredicate);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final PredicateDefinition definition;
        private final String predicateName;

        public Factory(PredicateDefinition definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.definition.equals(castedOther.definition)) {
                throw log.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new Builder(this.definition, this.predicateName, scope, node);
        }
    }
}

