/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDistanceToFieldProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchSimpleStandardFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinBoundingBoxPredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinCirclePredicate;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinPolygonPredicate;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchDistanceSort;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultParseConverters;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchGeoPointIndexFieldTypeOptionsStep
extends AbstractElasticsearchSimpleStandardFieldTypeOptionsStep<ElasticsearchGeoPointIndexFieldTypeOptionsStep, GeoPoint> {
    ElasticsearchGeoPointIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, GeoPoint.class, "geo_point", DefaultParseConverters.GEO_POINT);
    }

    @Override
    protected void complete() {
        ElasticsearchGeoPointFieldCodec codec = ElasticsearchGeoPointFieldCodec.INSTANCE;
        this.builder.codec(codec);
        this.resolvedProjectable = this.resolvedSortable = this.resolvedSortable || this.resolvedProjectable;
        this.builder.mapping().setDocValues(this.resolvedProjectable);
        if (this.resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_CIRCLE, new ElasticsearchGeoPointSpatialWithinCirclePredicate.Factory(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_POLYGON, new ElasticsearchGeoPointSpatialWithinPolygonPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.SPATIAL_WITHIN_BOUNDING_BOX, new ElasticsearchGeoPointSpatialWithinBoundingBoxPredicate.Factory(codec));
        }
        if (this.resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.DISTANCE, new ElasticsearchDistanceSort.Factory());
        }
        if (this.resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<GeoPoint>(codec));
            this.builder.queryElementFactory(ProjectionTypeKeys.DISTANCE, new ElasticsearchDistanceToFieldProjection.Factory());
        }
        if (this.resolvedAggregable) {
            this.builder.aggregable(true);
        }
    }

    @Override
    protected ElasticsearchGeoPointIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

