/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.impl.ElasticsearchAnalysisPerformer;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchIndexSchemaManager;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchSearchIndexScopeImpl;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryIndexScope;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchPropertyMappingValidatorProvider;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexer;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexIndexingPlan;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexWorkspace;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements SearchBackendContext,
WorkExecutionBackendContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<IndexStatus> LIFECYCLE_MINIMAL_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"schema_management.minimal_required_status").as(IndexStatus.class, IndexStatus::of).build();
    private static final ConfigurationProperty<Integer> LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"schema_management.minimal_required_status_wait_timeout").asIntegerPositiveOrZero().withDefault((Object)10000).build();
    private final ElasticsearchBackend backendAPI;
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final ElasticsearchLink link;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final IndexLayoutStrategy indexLayoutStrategy;
    private final FailureHandler failureHandler;
    private final TimingSource timingSource;
    private final ElasticsearchParallelWorkOrchestrator generalPurposeOrchestrator;
    private final ElasticsearchPropertyMappingValidatorProvider propertyMappingValidatorProvider;
    private final SearchProjectionBackendContext searchProjectionBackendContext;

    public IndexManagerBackendContext(ElasticsearchBackend backendAPI, EventContext eventContext, BackendThreads threads, ElasticsearchLink link, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy, IndexLayoutStrategy indexLayoutStrategy, TypeNameMapping typeNameMapping, FailureHandler failureHandler, TimingSource timingSource, ElasticsearchParallelWorkOrchestrator generalPurposeOrchestrator, ElasticsearchPropertyMappingValidatorProvider propertyMappingValidatorProvider) {
        this.backendAPI = backendAPI;
        this.eventContext = eventContext;
        this.threads = threads;
        this.link = link;
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.indexLayoutStrategy = indexLayoutStrategy;
        this.failureHandler = failureHandler;
        this.timingSource = timingSource;
        this.generalPurposeOrchestrator = generalPurposeOrchestrator;
        this.propertyMappingValidatorProvider = propertyMappingValidatorProvider;
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(typeNameMapping.getTypeNameExtractionHelper(), multiTenancyStrategy.idProjectionExtractionHelper());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public IndexIndexingPlan createIndexingPlan(ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext, DocumentRefreshStrategy refreshStrategy) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexingPlan(this.link.getWorkFactory(), orchestrator, indexManagerContext, sessionContext, refreshStrategy);
    }

    @Override
    public IndexIndexer createIndexer(ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexIndexer(this.link.getWorkFactory(), orchestrator, indexManagerContext, sessionContext);
    }

    @Override
    public IndexWorkspace createWorkspace(WorkExecutionIndexManagerContext indexManagerContext, Set<String> tenantIds) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(tenantIds, this.eventContext);
        return new ElasticsearchIndexWorkspace(this.link.getWorkFactory(), this.multiTenancyStrategy, this.generalPurposeOrchestrator, indexManagerContext, tenantIds);
    }

    @Override
    public SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    @Override
    public ElasticsearchSearchQueryIndexScope<?> createSearchContext(BackendMappingContext mappingContext, Set<ElasticsearchIndexModel> indexModels) {
        return new ElasticsearchSearchIndexScopeImpl(mappingContext, this, this.userFacingGson, this.link.getSearchSyntax(), this.multiTenancyStrategy, this.timingSource, indexModels);
    }

    @Override
    public <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<H> rootProjection) {
        this.multiTenancyStrategy.documentIdHelper().checkTenantId(sessionContext.tenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<H>(this.link.getWorkFactory(), this.link.getSearchResultExtractorFactory(), this.generalPurposeOrchestrator, scope, sessionContext, loadingContextBuilder, rootProjection, this.link.getScrollTimeout());
    }

    ElasticsearchBackend toAPI() {
        return this.backendAPI;
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    ElasticsearchIndexSchemaManager createSchemaManager(ElasticsearchIndexModel model, ConfigurationPropertySource indexPropertySource) {
        LowLevelIndexMetadataBuilder builder = new LowLevelIndexMetadataBuilder(this.link.getGsonProvider(), this.link.getIndexMetadataSyntax(), model.names());
        model.contributeLowLevelMetadata(builder);
        IndexMetadata expectedMetadata = builder.build();
        boolean isStatusCheckPossible = this.link.getWorkFactory().isWaitForIndexStatusSupported();
        ElasticsearchIndexLifecycleExecutionOptions executionOptions = new ElasticsearchIndexLifecycleExecutionOptions(((Optional)LIFECYCLE_MINIMAL_REQUIRED_STATUS.getAndTransform(indexPropertySource, optional -> {
            if (optional.isPresent() && !isStatusCheckPossible) {
                throw log.cannotRequireIndexStatus();
            }
            if (!optional.isPresent() && isStatusCheckPossible) {
                return Optional.of(IndexStatus.YELLOW);
            }
            return optional;
        })).orElse(null), (Integer)LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT.get(indexPropertySource));
        return new ElasticsearchIndexSchemaManager(this.backendAPI.name(), this.userFacingGson, this.link.getWorkFactory(), this.generalPurposeOrchestrator, this.indexLayoutStrategy, model.names(), expectedMetadata, executionOptions, this.propertyMappingValidatorProvider);
    }

    ElasticsearchBatchingWorkOrchestrator createIndexingOrchestrator(String indexName) {
        return new ElasticsearchBatchingWorkOrchestrator("Elasticsearch indexing orchestrator for index " + indexName, this.threads, this.link, this.failureHandler);
    }

    String toElasticsearchId(String tenantId, String id) {
        return this.multiTenancyStrategy.documentIdHelper().toElasticsearchId(tenantId, id);
    }

    public ElasticsearchAnalysisPerformer createAnalysisPerformer(ElasticsearchIndexModel model) {
        return new ElasticsearchAnalysisPerformer(model, this.link.getWorkFactory(), this.generalPurposeOrchestrator);
    }
}

