/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchBucketAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchRangeAggregation<F, K>
extends AbstractElasticsearchBucketAggregation<Range<K>, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final List<Range<K>> rangesInOrder;
    private final JsonArray rangesJson;

    private ElasticsearchRangeAggregation(Builder<F, K> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.rangesInOrder = builder.rangesInOrder;
        this.rangesJson = builder.rangesJson;
    }

    @Override
    protected void doRequest(JsonObject outerObject, JsonObject innerObject) {
        outerObject.add("range", (JsonElement)innerObject);
        innerObject.addProperty("field", this.absoluteFieldPath);
        innerObject.addProperty("keyed", Boolean.valueOf(true));
        innerObject.add("ranges", (JsonElement)this.rangesJson);
    }

    @Override
    protected ElasticsearchSearchAggregation.Extractor<Map<Range<K>, Long>> extractor(AggregationRequestContext context) {
        return new RangeBucketExtractor(this.nestedPathHierarchy, this.filter, this.rangesInOrder);
    }

    private static class Builder<F, K>
    extends AbstractElasticsearchBucketAggregation.AbstractBuilder<Range<K>, Long>
    implements RangeAggregationBuilder<K> {
        private final ElasticsearchFieldCodec<F> codec;
        private final DslConverter<? super K, F> toFieldValueConverter;
        private final List<Range<K>> rangesInOrder = new ArrayList<Range<K>>();
        private final JsonArray rangesJson = new JsonArray();

        private Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, DslConverter<? super K, F> toFieldValueConverter) {
            super(scope, field);
            this.codec = codec;
            this.toFieldValueConverter = toFieldValueConverter;
        }

        public void range(Range<? extends K> range) {
            Optional upperBoundValue;
            JsonObject rangeJson = new JsonObject();
            Optional lowerBoundValue = range.lowerBoundValue();
            if (lowerBoundValue.isPresent()) {
                if (!RangeBoundInclusion.INCLUDED.equals((Object)range.lowerBoundInclusion())) {
                    throw log.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("from", this.convertToFieldValue(lowerBoundValue.get()));
            }
            if ((upperBoundValue = range.upperBoundValue()).isPresent()) {
                if (!RangeBoundInclusion.EXCLUDED.equals((Object)range.upperBoundInclusion())) {
                    throw log.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("to", this.convertToFieldValue(upperBoundValue.get()));
            }
            rangeJson.addProperty("key", String.valueOf(this.rangesJson.size()));
            this.rangesInOrder.add(range.map(Function.identity()));
            this.rangesJson.add((JsonElement)rangeJson);
        }

        @Override
        public ElasticsearchRangeAggregation<F, K> build() {
            return new ElasticsearchRangeAggregation(this);
        }

        private JsonElement convertToFieldValue(K value) {
            try {
                Object converted = this.toFieldValueConverter.toDocumentValue(value, this.scope.toDocumentValueConvertContext());
                return this.codec.encodeForAggregation(this.scope.searchSyntax(), converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, this.field.eventContext());
            }
        }
    }

    protected class RangeBucketExtractor
    extends AbstractElasticsearchBucketAggregation.AbstractBucketExtractor<Range<K>, Long> {
        private final List<Range<K>> rangesInOrder;

        protected RangeBucketExtractor(List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter, List<Range<K>> rangesInOrder) {
            super(nestedPathHierarchy, filter);
            this.rangesInOrder = rangesInOrder;
        }

        @Override
        protected Map<Range<K>, Long> doExtract(AggregationExtractContext context, JsonElement buckets) {
            JsonObject bucketMap = buckets.getAsJsonObject();
            LinkedHashMap result = CollectionHelper.newLinkedHashMap((int)this.rangesInOrder.size());
            for (int i = 0; i < this.rangesInOrder.size(); ++i) {
                JsonObject bucket = bucketMap.get(String.valueOf(i)).getAsJsonObject();
                Range range = this.rangesInOrder.get(i);
                long documentCount = ElasticsearchRangeAggregation.this.getBucketDocCount(bucket);
                result.put(range, documentCount);
            }
            return result;
        }
    }

    private static class TypeSelector<F>
    implements RangeAggregationBuilder.TypeSelector {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <T> Builder<F, T> type(Class<T> expectedType, ValueConvert convert) {
            return new Builder(this.codec, this.scope, this.field, this.field.type().dslConverter(convert).withInputType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<RangeAggregationBuilder.TypeSelector, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public RangeAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            return new TypeSelector<F>(this.codec, scope, field);
        }
    }
}

