/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBigIntegerFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchNumericFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultParseConverters;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBigIntegerIndexFieldTypeOptionsStep
extends AbstractElasticsearchNumericFieldTypeOptionsStep<ElasticsearchBigIntegerIndexFieldTypeOptionsStep, BigInteger>
implements ScaledNumberIndexFieldTypeOptionsStep<ElasticsearchBigIntegerIndexFieldTypeOptionsStep, BigInteger> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    ElasticsearchBigIntegerIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigInteger.class, "scaled_float", DefaultParseConverters.BIG_INTEGER);
        this.defaultsProvider = defaultsProvider;
    }

    public ElasticsearchBigIntegerIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this.thisAsS();
    }

    @Override
    protected ElasticsearchFieldCodec<BigInteger> completeCodec() {
        int resolvedDecimalScale = this.resolveDecimalScale();
        if (resolvedDecimalScale > 0) {
            throw log.invalidDecimalScale(resolvedDecimalScale, this.buildContext.getEventContext());
        }
        ElasticsearchBigIntegerFieldCodec codec = new ElasticsearchBigIntegerFieldCodec(resolvedDecimalScale);
        this.builder.mapping().setScalingFactor(codec.scalingFactor().doubleValue());
        return codec;
    }

    @Override
    protected ElasticsearchBigIntegerIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.decimalScale() != null) {
            return this.defaultsProvider.decimalScale();
        }
        throw log.nullDecimalScale(this.buildContext.hints().missingDecimalScale(), this.buildContext.getEventContext());
    }
}

