/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch7ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch812ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch814ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch8ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.ElasticsearchModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.OpenSearch1ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.OpenSearch214ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.OpenSearch29ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.OpenSearch2ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.AmazonOpenSearchServerlessProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch70ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch80ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch81ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDialectFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Incubating
    public static final ElasticsearchVersion AMAZON_OPENSEARCH_SERVERLESS = ElasticsearchVersion.of(ElasticsearchDistributionName.AMAZON_OPENSEARCH_SERVERLESS, null);

    public static boolean isPreciseEnoughForModelDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: 
            case OPENSEARCH: {
                return version.majorOptional().isPresent();
            }
            case AMAZON_OPENSEARCH_SERVERLESS: {
                return true;
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + String.valueOf((Object)version.distribution()));
    }

    public static boolean isPreciseEnoughForProtocolDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: 
            case OPENSEARCH: {
                return version.majorOptional().isPresent() && version.minor().isPresent();
            }
            case AMAZON_OPENSEARCH_SERVERLESS: {
                return true;
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + String.valueOf((Object)version.distribution()));
    }

    public static boolean isVersionCheckImpossible(ElasticsearchVersion version) {
        return version.distribution().equals((Object)ElasticsearchDistributionName.AMAZON_OPENSEARCH_SERVERLESS);
    }

    public ElasticsearchModelDialect createModelDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: {
                return this.createModelDialectElastic(version);
            }
            case OPENSEARCH: {
                return this.createModelDialectOpenSearch(version);
            }
            case AMAZON_OPENSEARCH_SERVERLESS: {
                return this.createModelDialectAmazonOpenSearchServerless(version);
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + String.valueOf((Object)version.distribution()));
    }

    private ElasticsearchModelDialect createModelDialectElastic(ElasticsearchVersion version) {
        OptionalInt majorOptional = version.majorOptional();
        OptionalInt minorOptional = version.minor();
        if (majorOptional.isEmpty()) {
            throw new AssertionFailure("Cannot create the Elasticsearch model dialect because the version is incomplete.");
        }
        int major = majorOptional.getAsInt();
        if (major < 7 || major == 7 && minorOptional.isPresent() && minorOptional.getAsInt() < 10) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 7) {
            return new Elasticsearch7ModelDialect();
        }
        if (major == 8 && (minorOptional.isEmpty() || minorOptional.getAsInt() < 12)) {
            return new Elasticsearch8ModelDialect();
        }
        if (major == 8 && minorOptional.getAsInt() < 14) {
            return new Elasticsearch812ModelDialect();
        }
        return new Elasticsearch814ModelDialect();
    }

    private ElasticsearchModelDialect createModelDialectOpenSearch(ElasticsearchVersion version) {
        OptionalInt majorOptional = version.majorOptional();
        OptionalInt minorOptional = version.minor();
        if (majorOptional.isEmpty()) {
            throw new AssertionFailure("Cannot create the OpenSearch model dialect because the version is incomplete.");
        }
        int major = majorOptional.getAsInt();
        if (major < 1 || major == 1 && minorOptional.isPresent() && minorOptional.getAsInt() < 3) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 1) {
            return new OpenSearch1ModelDialect();
        }
        if (major == 2) {
            if (minorOptional.isEmpty() || minorOptional.getAsInt() < 9) {
                return new OpenSearch2ModelDialect();
            }
            if (minorOptional.getAsInt() < 14) {
                return new OpenSearch29ModelDialect();
            }
        }
        return new OpenSearch214ModelDialect();
    }

    private ElasticsearchModelDialect createModelDialectAmazonOpenSearchServerless(ElasticsearchVersion version) {
        if (!AMAZON_OPENSEARCH_SERVERLESS.equals(version)) {
            throw log.unexpectedAwsOpenSearchServerlessVersion(version, AMAZON_OPENSEARCH_SERVERLESS);
        }
        return new OpenSearch214ModelDialect();
    }

    public ElasticsearchProtocolDialect createProtocolDialect(ElasticsearchVersion version) {
        switch (version.distribution()) {
            case ELASTIC: {
                return this.createProtocolDialectElastic(version);
            }
            case OPENSEARCH: {
                return this.createProtocolDialectOpenSearch(version);
            }
            case AMAZON_OPENSEARCH_SERVERLESS: {
                return this.createProtocolDialectAmazonOpenSearchServerless(version);
            }
        }
        throw new AssertionFailure("Unrecognized Elasticsearch distribution: " + String.valueOf((Object)version.distribution()));
    }

    private ElasticsearchProtocolDialect createProtocolDialectElastic(ElasticsearchVersion version) {
        OptionalInt majorOptional = version.majorOptional();
        OptionalInt minorOptional = version.minor();
        if (majorOptional.isEmpty() || minorOptional.isEmpty()) {
            throw new AssertionFailure("Cannot create the Elasticsearch protocol dialect because the version is incomplete.");
        }
        int major = majorOptional.getAsInt();
        int minor = minorOptional.getAsInt();
        if (major < 7 || major == 7 && minor < 10) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 7) {
            return this.createProtocolDialectElasticV7(version, minor);
        }
        if (major == 8) {
            return this.createProtocolDialectElasticV8(version, minor);
        }
        log.unknownElasticsearchVersion(version);
        return new Elasticsearch81ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectElasticV7(ElasticsearchVersion version, int minor) {
        if (minor > 17) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectElasticV8(ElasticsearchVersion version, int minor) {
        if (minor > 14) {
            log.unknownElasticsearchVersion(version);
        } else if (minor == 0) {
            return new Elasticsearch80ProtocolDialect();
        }
        return new Elasticsearch81ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectOpenSearch(ElasticsearchVersion version) {
        OptionalInt majorOptional = version.majorOptional();
        OptionalInt minorOptional = version.minor();
        if (majorOptional.isEmpty() || minorOptional.isEmpty()) {
            throw new AssertionFailure("Cannot create the OpenSearch protocol dialect because the version is incomplete.");
        }
        int major = majorOptional.getAsInt();
        int minor = minorOptional.getAsInt();
        if (major < 1 || major == 1 && minor < 3) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 1) {
            return this.createProtocolDialectOpenSearchV1(version, minor);
        }
        if (major == 2) {
            return this.createProtocolDialectOpenSearchV2(version, minor);
        }
        log.unknownElasticsearchVersion(version);
        return new Elasticsearch70ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectOpenSearchV1(ElasticsearchVersion version, int minor) {
        if (minor > 3) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectOpenSearchV2(ElasticsearchVersion version, int minor) {
        if (minor > 15) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }

    private ElasticsearchProtocolDialect createProtocolDialectAmazonOpenSearchServerless(ElasticsearchVersion version) {
        if (!AMAZON_OPENSEARCH_SERVERLESS.equals(version)) {
            throw log.unexpectedAwsOpenSearchServerlessVersion(version, AMAZON_OPENSEARCH_SERVERLESS);
        }
        return new AmazonOpenSearchServerlessProtocolDialect();
    }
}

