/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AccumulatingSourceExtractor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchFieldProjection<F, V, P, T>
extends AbstractElasticsearchProjection<P> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final String[] absoluteFieldPathComponents;
    private final String requiredContextAbsoluteFieldPath;
    private final Function<JsonElement, T> decodeFunction;
    private final boolean canDecodeArrays;
    private final ProjectionConverter<? super T, ? extends V> converter;
    private final ProjectionAccumulator.Provider<V, P> accumulatorProvider;

    private ElasticsearchFieldProjection(Builder<F, V, T> builder, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
        this(builder.scope, builder.field, builder.decodeFunction, builder.canDecodeArrays, builder.converter, accumulatorProvider);
    }

    ElasticsearchFieldProjection(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, Function<JsonElement, T> decodeFunction, boolean canDecodeArrays, ProjectionConverter<? super T, ? extends V> converter, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
        super(scope);
        this.absoluteFieldPath = field.absolutePath();
        this.absoluteFieldPathComponents = field.absolutePathComponents();
        this.requiredContextAbsoluteFieldPath = accumulatorProvider.isSingleValued() ? field.closestMultiValuedParentAbsolutePath() : null;
        this.decodeFunction = decodeFunction;
        this.canDecodeArrays = canDecodeArrays;
        this.converter = converter;
        this.accumulatorProvider = accumulatorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", accumulatorProvider=" + String.valueOf(this.accumulatorProvider) + "]";
    }

    public ValueFieldExtractor<?> request(JsonObject requestBody, ProjectionRequestContext context) {
        ProjectionRequestContext innerContext = context.forField(this.absoluteFieldPath, this.absoluteFieldPathComponents);
        if (this.requiredContextAbsoluteFieldPath != null && !this.requiredContextAbsoluteFieldPath.equals(context.absoluteCurrentFieldPath())) {
            throw log.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        JsonPrimitive fieldPathJson = new JsonPrimitive(this.absoluteFieldPath);
        AccumulatingSourceExtractor.REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)fieldPathJson);
        return new ValueFieldExtractor(innerContext.relativeCurrentFieldPathComponents(), this.accumulatorProvider.get());
    }

    public static class Builder<F, V, T>
    implements FieldProjectionBuilder<V> {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final Function<JsonElement, T> decodeFunction;
        private final boolean canDecodeArrays;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;
        private final ProjectionConverter<T, ? extends V> converter;

        private Builder(Function<JsonElement, T> decodeFunction, boolean canDecodeArrays, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, ProjectionConverter<T, ? extends V> converter) {
            this.decodeFunction = decodeFunction;
            this.canDecodeArrays = canDecodeArrays;
            this.scope = scope;
            this.field = field;
            this.converter = converter;
        }

        public <P> SearchProjection<P> build(ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.field.multiValued()) {
                throw log.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new ElasticsearchFieldProjection(this, accumulatorProvider);
        }
    }

    private class ValueFieldExtractor<A>
    extends AccumulatingSourceExtractor<T, V, A, P> {
        public ValueFieldExtractor(String[] fieldPathComponents, ProjectionAccumulator<T, V, A, P> accumulator) {
            super(fieldPathComponents, accumulator);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[absoluteFieldPath=" + ElasticsearchFieldProjection.this.absoluteFieldPath + ", accumulator=" + String.valueOf(this.accumulator) + "]";
        }

        @Override
        protected T extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonElement sourceElement, ProjectionExtractContext context) {
            return ElasticsearchFieldProjection.this.decodeFunction.apply(sourceElement);
        }

        @Override
        protected boolean canDecodeArrays() {
            return ElasticsearchFieldProjection.this.canDecodeArrays;
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            Object transformedData = this.accumulator.transformAll(extractedData, ElasticsearchFieldProjection.this.converter, convertContext);
            return this.accumulator.finish(transformedData);
        }
    }

    public static class TypeSelector<F>
    implements FieldProjectionBuilder.TypeSelector {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <V> Builder<F, V, ?> type(Class<V> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new Builder(Function.identity(), this.codec.canDecodeArrays(), this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field));
            }
            return new Builder(this.codec::decode, this.codec.canDecodeArrays(), this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<FieldProjectionBuilder.TypeSelector, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            field.nestedPathHierarchy();
            return new TypeSelector<F>(this.codec, scope, field);
        }
    }
}

