/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.search.predicate.spi.MinimumShouldMatchBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ElasticsearchCommonMinimumShouldMatchConstraints
implements MinimumShouldMatchBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private Map<Integer, CommonMinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new CommonMinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new CommonMinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, CommonMinimumShouldMatchConstraint constraint) {
        CommonMinimumShouldMatchConstraint previous;
        if (this.minimumShouldMatchConstraints == null) {
            this.minimumShouldMatchConstraints = new TreeMap<Integer, CommonMinimumShouldMatchConstraint>();
        }
        if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
            throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
        }
    }

    public String formatMinimumShouldMatchConstraints() {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, CommonMinimumShouldMatchConstraint>> iterator = this.minimumShouldMatchConstraints.entrySet().iterator();
        Map.Entry<Integer, CommonMinimumShouldMatchConstraint> entry = iterator.next();
        Integer ignoreConstraintCeiling = entry.getKey();
        CommonMinimumShouldMatchConstraint constraint = entry.getValue();
        if (ignoreConstraintCeiling.equals(0) && this.minimumShouldMatchConstraints.size() == 1) {
            constraint.appendTo(builder, null);
            return builder.toString();
        }
        entry.getValue().appendTo(builder, ignoreConstraintCeiling);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ignoreConstraintCeiling = entry.getKey();
            constraint = entry.getValue();
            builder.append(' ');
            constraint.appendTo(builder, ignoreConstraintCeiling);
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.minimumShouldMatchConstraints == null;
    }

    private static final class CommonMinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        CommonMinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        void appendTo(StringBuilder builder, Integer ignoreConstraintCeiling) {
            if (ignoreConstraintCeiling != null) {
                builder.append(ignoreConstraintCeiling).append('<');
            }
            if (this.matchingClausesNumber != null) {
                builder.append(this.matchingClausesNumber);
            } else {
                builder.append(this.matchingClausesPercent).append('%');
            }
        }
    }
}

