package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import java.lang.String;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.jboss.logging.Logger;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import java.util.List;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.engine.search.projection.SearchProjection;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.search.engine.search.sort.SearchSort;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class QueryLog_$logger implements QueryLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    public QueryLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void executingElasticsearchQuery(final String path, final Map<String, String> parameters, final String bodyParts) {
        log.logf(FQCN, TRACE, null, executingElasticsearchQuery$str(), path, parameters, bodyParts);
    }
    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }
    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager elasticsearchIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.";
    }
    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(final IndexScopeBuilder baseScope, final ElasticsearchIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ceiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ceiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fullTextFeaturesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.";
    }
    @Override
    public final SearchException fullTextFeaturesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), fullTextFeaturesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeName$str() {
        return "HSEARCH400564: Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.";
    }
    @Override
    public final SearchException explainRequiresTypeName(final Set<String> targetedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeName$str(), targetedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH400565: Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Invalid document identifier: '%2$s'. No such document in index '%1$s'.";
    }
    @Override
    public final SearchException explainUnknownDocument(final URLEncodedString indexName, final URLEncodedString id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnknownDocument$str(), indexName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort sort, final Set<String> sortIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), sort, sortIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> projection, final Set<String> projectionIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), projection, projectionIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.";
    }
    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(final Range<?> range) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Duplicate aggregation definitions for key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey<?> key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException missingTypeFieldInDocument(final String fieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingTypeFieldInDocument$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeAcrossNested$str() {
        return "HSEARCH400600: Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.";
    }
    @Override
    public final SearchException invalidSortModeAcrossNested(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeAcrossNested$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForStringField$str() {
        return "HSEARCH400601: Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.";
    }
    @Override
    public final SearchException invalidSortModeForStringField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForStringField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForTemporalField$str() {
        return "HSEARCH400602: Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForTemporalField(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForTemporalField$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSortModeForDistanceSort$str() {
        return "HSEARCH400603: Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.";
    }
    @Override
    public final SearchException invalidSortModeForDistanceSort(final SortMode mode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSortModeForDistanceSort$str(), mode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH400604: Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH400605: Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final SearchPredicate predicate, final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), predicate, nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH400606: Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnMultiValuedField$str() {
        return "HSEARCH400613: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnMultiValuedField(final String absolutePath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnMultiValuedField$str(), absolutePath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentImplementationClassForQueryElement$str() {
        return "HSEARCH400617: Implementation class differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentImplementationClassForQueryElement(final Class<?> class1, final Class<?> class2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentImplementationClassForQueryElement$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class1), new org.hibernate.search.util.common.logging.impl.ClassFormatter(class2)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentFieldCodecForQueryElement$str() {
        return "HSEARCH400618: Field codec differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentFieldCodecForQueryElement(final Object codec1, final Object codec2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentFieldCodecForQueryElement$str(), codec1, codec2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingFirstOnAscSortNotSupported$str() {
        return "HSEARCH400634: Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingFirstOnAscSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFirstOnAscSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLastOnDescSortNotSupported$str() {
        return "HSEARCH400635: Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingLastOnDescSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLastOnDescSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingAsOnSortNotSupported$str() {
        return "HSEARCH400636: Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.";
    }
    @Override
    public final SearchException missingAsOnSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingAsOnSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String differentPredicateDefinitionForQueryElement$str() {
        return "HSEARCH400638: Predicate definition differs: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException differentPredicateDefinitionForQueryElement(final Object predicateDefinition1, final Object predicateDefinition2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), differentPredicateDefinitionForQueryElement$str(), predicateDefinition1, predicateDefinition2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void defaultedLimitedHits(final Integer defaultLimit, final long hitCount) {
        log.logf(FQCN, WARN, null, defaultedLimitedHits$str(), defaultLimit, hitCount);
    }
    protected String defaultedLimitedHits$str() {
        return "HSEARCH400640: A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.";
    }
    protected String paramNotDefined$str() {
        return "HSEARCH400650: Param with name '%1$s' has not been defined for the named predicate '%2$s'.";
    }
    @Override
    public final SearchException paramNotDefined(final String name, final String predicateName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), paramNotDefined$str(), name, predicateName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContextForProjectionOnField$str() {
        return "HSEARCH400654: Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.";
    }
    @Override
    public final SearchException invalidContextForProjectionOnField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContextForProjectionOnField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str() {
        return "HSEARCH400655: Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.";
    }
    @Override
    public final SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(final String absolutePath, final String objectFieldAbsolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField$str(), absolutePath, objectFieldAbsolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedMappedTypeNameForByMappedTypeProjection$str() {
        return "HSEARCH400656: Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }
    @Override
    public final SearchException unexpectedMappedTypeNameForByMappedTypeProjection(final String typeName, final Set<String> expectedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedMappedTypeNameForByMappedTypeProjection$str(), typeName, expectedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLowestOnAscSortNotSupported$str() {
        return "HSEARCH400658: Invalid use of 'missing().lowest()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }
    @Override
    public final SearchException missingLowestOnAscSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLowestOnAscSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingLowestOnDescSortNotSupported$str() {
        return "HSEARCH400659: Invalid use of 'missing().lowest()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ";
    }
    @Override
    public final SearchException missingLowestOnDescSortNotSupported(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingLowestOnDescSortNotSupported$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str() {
        return "HSEARCH400660: Invalid highlighter: '%1$s'. You must build the highlighter from an Elasticsearch search scope.";
    }
    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(final SearchHighlighter highlighter) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters$str(), highlighter));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queryHighlighterDefinedOnDifferentIndexes$str() {
        return "HSEARCH400661: Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.";
    }
    @Override
    public final SearchException queryHighlighterDefinedOnDifferentIndexes(final SearchHighlighter highlighter, final Set<String> highlighterIndexes, final Set<String> scopeIndexes, final Set<String> scopeDifference) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), queryHighlighterDefinedOnDifferentIndexes$str(), highlighter, highlighterIndexes, scopeIndexes, scopeDifference));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noFieldsToHighlight() {
        log.logf(FQCN, WARN, null, noFieldsToHighlight$str());
    }
    protected String noFieldsToHighlight$str() {
        return "HSEARCH400662: No fields were added to be highlighted, but some query level highlighters were provided. These highlighters will be ignored.";
    }
    protected String cannotFindHighlighter$str() {
        return "HSEARCH400663: Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?";
    }
    @Override
    public final SearchException cannotFindHighlighter(final String highlighterName, final Set<String> highlighters) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindHighlighter$str(), highlighterName, highlighters));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterNameCannotBeBlank$str() {
        return "HSEARCH400664: Named highlighters cannot use a blank string as name.";
    }
    @Override
    public final SearchException highlighterNameCannotBeBlank() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterNameCannotBeBlank$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterWithTheSameNameCannotBeAdded$str() {
        return "HSEARCH400665: Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.";
    }
    @Override
    public final SearchException highlighterWithTheSameNameCannotBeAdded(final String highlighterName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterWithTheSameNameCannotBeAdded$str(), highlighterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String highlighterTypeNotSupported$str() {
        return "HSEARCH400666: '%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.";
    }
    @Override
    public final SearchException highlighterTypeNotSupported(final SearchHighlighterType type, final String field) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterTypeNotSupported$str(), type, field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightInNestedContext$str() {
        return "HSEARCH400670: Highlight projection cannot be applied within nested context of '%1$s'.";
    }
    @Override
    public final SearchException cannotHighlightInNestedContext(final String currentNestingField, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightInNestedContext$str(), currentNestingField), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotHighlightFieldFromNestedObjectStructure$str() {
        return "HSEARCH400671: The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.";
    }
    @Override
    public final SearchException cannotHighlightFieldFromNestedObjectStructure(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotHighlightFieldFromNestedObjectStructure$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseProjectionInNestedContext$str() {
        return "HSEARCH400672: '%1$s' cannot be nested in an object projection. %2$s";
    }
    @Override
    public final SearchException cannotUseProjectionInNestedContext(final String projection, final String hint, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseProjectionInNestedContext$str(), projection, hint), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorTypeDiffersFromField$str() {
        return "HSEARCH400681: Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorTypeDiffersFromField(final String absoluteFieldPath, final Class<?> expected, final Class<?> actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorTypeDiffersFromField$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expected), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actual)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorKnnMatchVectorDimensionDiffersFromField$str() {
        return "HSEARCH400682: Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.";
    }
    @Override
    public final SearchException vectorKnnMatchVectorDimensionDiffersFromField(final String absoluteFieldPath, final int expected, final int actual) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorKnnMatchVectorDimensionDiffersFromField$str(), absoluteFieldPath, expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String knnRequiredMinimumSimilarityUnsupportedOption$str() {
        return "HSEARCH400687: An OpenSearch distribution does not allow specifying the `required minimum similarity` option. This option is only applicable to an Elastic distribution of an Elasticsearch backend.";
    }
    @Override
    public final SearchException knnRequiredMinimumSimilarityUnsupportedOption() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), knnRequiredMinimumSimilarityUnsupportedOption$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void knnUsedInNestedContextRequiresFilters() {
        log.logf(FQCN, WARN, null, knnUsedInNestedContextRequiresFilters$str());
    }
    protected String knnUsedInNestedContextRequiresFilters$str() {
        return "HSEARCH400689: Using a knn predicate in the nested context when tenant or routing filters are required will lead to unpredictable results and may return fewer documents then expected.";
    }
    protected String highlighterIncompatibleCardinality$str() {
        return "HSEARCH400690: A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.";
    }
    @Override
    public final SearchException highlighterIncompatibleCardinality() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), highlighterIncompatibleCardinality$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
