/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.logging.impl.VersionLog;

public class ElasticsearchVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:-(\\w+))?)?)?");
    private static final String SEPARATOR_PATTERN_STRING = "(?<=^)|(?=$)|(?<=.):(?=.)";
    private static final Pattern DISTRIBUTION_AND_VERSION_PATTERN = Pattern.compile("([^\\d]+)?(?:(?<=^)|(?=$)|(?<=.):(?=.))(" + VERSION_PATTERN.pattern() + ")?");
    private final ElasticsearchDistributionName distribution;
    private final Integer major;
    private final Integer minor;
    private final Integer micro;
    private final String qualifier;

    public static ElasticsearchVersion of(String distributionAndVersionString) {
        String normalizedDistributionAndVersionString = distributionAndVersionString.trim().toLowerCase(Locale.ROOT);
        Matcher distributionAndVersionMatcher = DISTRIBUTION_AND_VERSION_PATTERN.matcher(normalizedDistributionAndVersionString);
        if (!distributionAndVersionMatcher.matches()) {
            throw VersionLog.INSTANCE.invalidElasticsearchVersionWithOptionalDistribution(normalizedDistributionAndVersionString, ElasticsearchDistributionName.allowedExternalRepresentations(), ElasticsearchDistributionName.defaultValue().externalRepresentation(), null);
        }
        try {
            String distributionString = distributionAndVersionMatcher.group(1);
            return ElasticsearchVersion.of(distributionString == null ? ElasticsearchDistributionName.defaultValue() : ElasticsearchDistributionName.of(distributionString), distributionAndVersionMatcher.group(2));
        }
        catch (RuntimeException e) {
            throw VersionLog.INSTANCE.invalidElasticsearchVersionWithOptionalDistribution(normalizedDistributionAndVersionString, ElasticsearchDistributionName.allowedExternalRepresentations(), ElasticsearchDistributionName.defaultValue().externalRepresentation(), e);
        }
    }

    public static ElasticsearchVersion of(ElasticsearchDistributionName distribution, String versionString) {
        if (versionString == null) {
            return new ElasticsearchVersion(distribution, null, null, null, null);
        }
        String normalizedVersion = versionString.trim().toLowerCase(Locale.ROOT);
        Matcher matcher = VERSION_PATTERN.matcher(normalizedVersion);
        if (!matcher.matches()) {
            throw VersionLog.INSTANCE.invalidElasticsearchVersionWithoutDistribution(normalizedVersion, null);
        }
        try {
            int major = ElasticsearchVersion.parseVersionComponent(matcher.group(1));
            Integer minor = ElasticsearchVersion.parseVersionComponent(matcher.group(2));
            Integer micro = ElasticsearchVersion.parseVersionComponent(matcher.group(3));
            String qualifier = matcher.group(4);
            return new ElasticsearchVersion(distribution, major, minor, micro, qualifier);
        }
        catch (RuntimeException e) {
            throw VersionLog.INSTANCE.invalidElasticsearchVersionWithoutDistribution(normalizedVersion, e);
        }
    }

    private static Integer parseVersionComponent(String string) {
        return string == null ? null : Integer.valueOf(Integer.parseInt(string));
    }

    private ElasticsearchVersion(ElasticsearchDistributionName distribution, Integer major, Integer minor, Integer micro, String qualifier) {
        this.distribution = distribution;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchVersion that = (ElasticsearchVersion)o;
        return this.distribution == that.distribution && Objects.equals(this.major, that.major) && Objects.equals(this.minor, that.minor) && Objects.equals(this.micro, that.micro) && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.distribution, this.major, this.minor, this.micro, this.qualifier});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.distribution);
        if (this.major == null) {
            return builder.toString();
        }
        builder.append(':').append(this.major);
        if (this.minor != null) {
            builder.append('.').append(this.minor);
        }
        if (this.micro != null) {
            builder.append('.').append(this.micro);
        }
        if (this.qualifier != null) {
            builder.append('-').append(this.qualifier);
        }
        return builder.toString();
    }

    public String versionString() {
        if (this.major == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        if (this.minor != null) {
            builder.append('.').append(this.minor);
        }
        if (this.micro != null) {
            builder.append('.').append(this.micro);
        }
        if (this.qualifier != null) {
            builder.append('-').append(this.qualifier);
        }
        return builder.toString();
    }

    public ElasticsearchDistributionName distribution() {
        return this.distribution;
    }

    @Deprecated
    public int major() {
        if (this.major == null) {
            return 0;
        }
        return this.major;
    }

    public OptionalInt majorOptional() {
        return this.major == null ? OptionalInt.empty() : OptionalInt.of(this.major);
    }

    public OptionalInt minor() {
        return this.minor == null ? OptionalInt.empty() : OptionalInt.of(this.minor);
    }

    public OptionalInt micro() {
        return this.micro == null ? OptionalInt.empty() : OptionalInt.of(this.micro);
    }

    public Optional<String> qualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public boolean matches(ElasticsearchVersion other) {
        return !(!this.distribution.equals((Object)other.distribution) || this.major != null && !this.major.equals(other.major) || this.minor != null && !this.minor.equals(other.minor) || this.micro != null && !this.micro.equals(other.micro) || this.qualifier != null && !this.qualifier.equals(other.qualifier));
    }
}

