/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonObject;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.jboss.logging.Logger;

public class ElasticsearchClientLog_$logger
implements ElasticsearchClientLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElasticsearchClientLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ElasticsearchClientLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchRequestFailed(ElasticsearchRequest request, ElasticsearchResponse response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchBulkedRequestFailed(JsonObject requestMetadata, JsonObject response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchStatus408RequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch response indicates a timeout (HTTP status 408)";
    }

    @Override
    public final SearchException elasticsearchStatus408RequestTimeout() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchStatus408RequestTimeout$str(), new Object[0]));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchMappingUpdateFailed$str() {
        return "HSEARCH400020: Unable to update mapping for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchMappingUpdateFailed(String indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$sms.";
    }

    @Override
    public final SearchException unexpectedIndexStatus(URLEncodedString indexName, String expected, int requiredStatusTimeoutInMs, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatus$str(), indexName, expected, requiredStatusTimeoutInMs), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Unable to retrieve index metadata from Elasticsearch: %1$s";
    }

    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexMetadataRetrievalFailed$str(), causeMessage), cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Unable to update schema for index '%1$s': %2$s";
    }

    @Override
    public final SearchException schemaUpdateFailed(URLEncodedString indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexMissing$str() {
        return "HSEARCH400050: Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }

    @Override
    public final SearchException indexMissing(URLEncodedString write, URLEncodedString read) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexMissing$str(), write, read));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Unable to update settings for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(Object indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSettingsUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void closedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedIndex$str(), indexName);
    }

    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void openedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.openedIndex$str(), indexName);
    }

    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void usingPasswordOverHttp() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), new Object[0]);
    }

    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }

    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s";
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase, causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }

    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseIndicatesFailure$str(), new Object[0]));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Missing data in the Elasticsearch response.";
    }

    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.elasticsearchResponseMissingData$str(), new Object[0]));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Unable to resolve index name '%1$s' to an entity type: %2$s";
    }

    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(String elasticsearchIndexName, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), (Throwable)e);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToShutdownClient$str() {
        return "HSEARCH400544: Unable to shut down the Elasticsearch client: %1$s";
    }

    @Override
    public final SearchException unableToShutdownClient(String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToShutdownClient$str(), causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: Call to the bulk REST API failed: %1$s";
    }

    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchFailedBecauseOfBulkFailure$str(), causeMessage), cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requestTimedOut$str() {
        return "HSEARCH400590: Request execution exceeded the timeout of %1$s. Request was %2$s";
    }

    @Override
    public final SearchTimeoutException requestTimedOut(Duration timeout, ElasticsearchRequest request) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.requestTimedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.";
    }

    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString write, URLEncodedString read, Set<String> matchingIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.";
    }

    @Override
    public final SearchException invalidIndexPrimaryName(String elasticsearchIndexName, Pattern pattern) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.";
    }

    @Override
    public final SearchException invalidIndexUniqueKey(String uniqueKey, Set<String> knownKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elasticsearchAliasUpdateFailed$str() {
        return "HSEARCH400625: Unable to update aliases for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchAliasUpdateFailed(Object indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchAliasUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        ElasticsearchClientLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

