/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.query.elasticsearch", description="Logs the Elasticsearch queries that are about to be executed and other query related messages.\n")
@MessageLogger(projectCode="HSEARCH")
public interface QueryLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.query.elasticsearch";
    public static final QueryLog INSTANCE = (QueryLog)LoggerFactory.make(QueryLog.class, (String)"org.hibernate.search.query.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400053, value="Executing Elasticsearch query on '%s' with parameters '%s': <%s>")
    public void executingElasticsearchQuery(String var1, Map<String, String> var2, String var3);

    @Message(id=400502, value="Invalid multi-index scope: a scope cannot span both a Elasticsearch index and another type of index. Base scope: '%1$s', incompatible (Elasticsearch) index: '%2$s'.")
    public SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400503, value="Invalid multi-index scope: a scope cannot span multiple Elasticsearch backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.")
    public SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400508, value="Invalid search predicate: '%1$s'. You must build the predicate from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=400511, value="Invalid search sort: '%1$s'. You must build the sort from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=400529, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=400538, value="Invalid search projection: '%1$s'. You must build the projection from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=400553, value="Full-text features (analysis, fuzziness, minimum should match) are not supported for fields of this type.")
    public SearchException fullTextFeaturesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400564, value="Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.")
    public SearchException explainRequiresTypeName(Set<String> var1);

    @Message(id=400565, value="Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.")
    public SearchException explainRequiresTypeTargetedByQuery(Set<String> var1, String var2);

    @Message(id=400566, value="Invalid document identifier: '%2$s'. No such document in index '%1$s'.")
    public SearchException explainUnknownDocument(URLEncodedString var1, URLEncodedString var2);

    @Message(id=400572, value="Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s or a superset of them, but the given predicate was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=400573, value="Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s or a superset of them, but the given sort was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=400574, value="Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s or a superset of them, but the given projection was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=400580, value="Invalid range: '%1$s'. Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). Call Range.canonical(...) to be sure to create such a range.")
    public SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> var1);

    @Message(id=400581, value="Invalid search aggregation: '%1$s'. You must build the aggregation from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=400582, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s or a superset of them, but the given aggregation was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @Message(id=400585, value="Duplicate aggregation definitions for key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey<?> var1);

    @Message(id=400592, value="Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException missingTypeFieldInDocument(String var1);

    @Message(id=400600, value="Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.")
    public SearchException invalidSortModeAcrossNested(SortMode var1, @Param EventContext var2);

    @Message(id=400601, value="Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.")
    public SearchException invalidSortModeForStringField(SortMode var1, @Param EventContext var2);

    @Message(id=400602, value="Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForTemporalField(SortMode var1, @Param EventContext var2);

    @Message(id=400603, value="Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForDistanceSort(SortMode var1, @Param EventContext var2);

    @Message(id=400604, value="Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.")
    public SearchException cannotFilterSortOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400605, value="Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.")
    public SearchException invalidNestedObjectPathForPredicate(SearchPredicate var1, String var2, List<String> var3);

    @Message(id=400606, value="Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.")
    public SearchException cannotFilterAggregationOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400613, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.collector(...)' when you create the projection.")
    public SearchException invalidSingleValuedProjectionOnMultiValuedField(String var1, @Param EventContext var2);

    @Message(id=400617, value="Implementation class differs: '%1$s' vs. '%2$s'.")
    public SearchException differentImplementationClassForQueryElement(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=400618, value="Field codec differs: '%1$s' vs. '%2$s'.")
    public SearchException differentFieldCodecForQueryElement(Object var1, Object var2);

    @Message(id=400634, value="Invalid use of 'missing().first()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingFirstOnAscSortNotSupported(@Param EventContext var1);

    @Message(id=400635, value="Invalid use of 'missing().last()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingLastOnDescSortNotSupported(@Param EventContext var1);

    @Message(id=400636, value="Invalid use of 'missing().use(...)' for a distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized.")
    public SearchException missingAsOnSortNotSupported(@Param EventContext var1);

    @Message(id=400638, value="Predicate definition differs: '%1$s' vs. '%2$s'.")
    public SearchException differentPredicateDefinitionForQueryElement(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400640, value="A search query fetching all hits was requested, but only '%2$s' hits were retrieved because the maximum result window size forces a limit of '%1$s' hits. Refer to Elasticsearch's 'max_result_window_size' setting for more information.")
    public void defaultedLimitedHits(Integer var1, long var2);

    @Message(id=400650, value="Param with name '%1$s' has not been defined for the named predicate '%2$s'.")
    public SearchException paramNotDefined(String var1, String var2, @Param EventContext var3);

    @Message(id=400654, value="Invalid context for projection on field '%1$s': the surrounding projection is executed for each object in field '%2$s', which is not a parent of field '%1$s'. Check the structure of your projections.")
    public SearchException invalidContextForProjectionOnField(String var1, String var2);

    @Message(id=400655, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is effectively multi-valued in this context, because parent object field '%2$s' is multi-valued. Either call '.collector(...)' when you create the projection on field '%1$s', or wrap that projection in an object projection like this: 'f.object(\"%2$s\").from(<the projection on field %1$s>).as(...).collector(...)'.")
    public SearchException invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(String var1, String var2);

    @Message(id=400656, value="Unexpected mapped type name extracted from hits: '%1$s'. Expected one of: %2$s. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException unexpectedMappedTypeNameForByMappedTypeProjection(String var1, Set<String> var2);

    @Message(id=400658, value="Invalid use of 'missing().lowest()' for an ascending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ")
    public SearchException missingLowestOnAscSortNotSupported(@Param EventContext var1);

    @Message(id=400659, value="Invalid use of 'missing().lowest()' for a descending distance sort. Elasticsearch always assumes missing values have a distance of '+Infinity', and this behavior cannot be customized. ")
    public SearchException missingLowestOnDescSortNotSupported(@Param EventContext var1);

    @Message(id=400660, value="Invalid highlighter: '%1$s'. You must build the highlighter from an Elasticsearch search scope.")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(SearchHighlighter var1);

    @Message(id=400661, value="Invalid highlighter: '%1$s'. You must build the highlighter from a scope targeting indexes %3$s or a superset of them, but the given highlighter was built from a scope targeting indexes %2$s, where indexes %4$s are missing.")
    public SearchException queryHighlighterDefinedOnDifferentIndexes(SearchHighlighter var1, Set<String> var2, Set<String> var3, Set<String> var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400662, value="No fields were added to be highlighted, but some query level highlighters were provided. These highlighters will be ignored.")
    public void noFieldsToHighlight();

    @Message(id=400663, value="Cannot find a highlighter with name '%1$s'. Available highlighters are: %2$s. Was it configured with `highlighter(\"%1$s\", highlighterContributor)`?")
    public SearchException cannotFindHighlighter(String var1, Set<String> var2);

    @Message(id=400664, value="Named highlighters cannot use a blank string as name.")
    public SearchException highlighterNameCannotBeBlank();

    @Message(id=400665, value="Highlighter with name '%1$s' is already defined. Use a different name to add another highlighter.")
    public SearchException highlighterWithTheSameNameCannotBeAdded(String var1);

    @Message(id=400666, value="'%1$s' highlighter type cannot be applied to '%2$s' field. '%2$s' must have either 'ANY' or '%1$s' among the configured highlightable values.")
    public SearchException highlighterTypeNotSupported(SearchHighlighterType var1, String var2);

    @Message(id=400670, value="Highlight projection cannot be applied within nested context of '%1$s'.")
    public SearchException cannotHighlightInNestedContext(String var1, @Param EventContext var2);

    @Message(id=400671, value="The highlight projection cannot be applied to a field from an object using `ObjectStructure.NESTED` structure.")
    public SearchException cannotHighlightFieldFromNestedObjectStructure(@Param EventContext var1);

    @Message(id=400672, value="'%1$s' cannot be nested in an object projection. %2$s")
    public SearchException cannotUseProjectionInNestedContext(String var1, String var2, @Param EventContext var3);

    @Message(id=400681, value="Vector field '%1$s' is defined as a '%2$s' array. Matching against '%3$s' array is unsupported. Use the array of the same type as the vector field.")
    public SearchException vectorKnnMatchVectorTypeDiffersFromField(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=400682, value="Vector field '%1$s' is defined as a vector with '%2$s' dimensions (array length). Matching against an array with length of '%3$s' is unsupported. Use the array of the same size as the vector field.")
    public SearchException vectorKnnMatchVectorDimensionDiffersFromField(String var1, int var2, int var3);

    @Message(id=400687, value="An OpenSearch distribution does not allow specifying the `required minimum similarity` option. This option is only applicable to an Elastic distribution of an Elasticsearch backend.")
    public SearchException knnRequiredMinimumSimilarityUnsupportedOption();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400689, value="Using a knn predicate in the nested context when tenant or routing filters are required will lead to unpredictable results and may return fewer documents then expected.")
    public void knnUsedInNestedContextRequiresFilters();

    @Message(id=400690, value="A single-valued highlight projection requested, but the corresponding highlighter does not set number of fragments to 1.")
    public SearchException highlighterIncompatibleCardinality();
}

