/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.schema.management.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;

final class ElasticsearchSchemaMigrator {
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public ElasticsearchSchemaMigrator(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    public CompletableFuture<?> migrate(URLEncodedString indexName, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata, OperationSubmitter operationSubmitter) {
        CompletableFuture<Object> aliasMigration = this.schemaValidator.isAliasesValid(expectedIndexMetadata, actualIndexMetadata) ? CompletableFuture.completedFuture(null) : this.doMigrateAliases(indexName, expectedIndexMetadata.getAliases(), operationSubmitter);
        CompletionStage<Object> settingsMigration = this.schemaValidator.isSettingsValid(expectedIndexMetadata, actualIndexMetadata) ? aliasMigration : aliasMigration.thenCompose(ignored -> this.doMigrateSettings(indexName, expectedIndexMetadata.getSettings(), actualIndexMetadata.getSettings(), operationSubmitter));
        CompletionStage<Object> mappingMigration = this.schemaValidator.isMappingValid(expectedIndexMetadata, actualIndexMetadata) ? settingsMigration : ((CompletableFuture)settingsMigration).thenCompose(ignored -> this.doMigrateMapping(indexName, expectedIndexMetadata.getMapping(), operationSubmitter));
        return ((CompletableFuture)mappingMigration).exceptionally(Futures.handler(e -> {
            throw ElasticsearchClientLog.INSTANCE.schemaUpdateFailed(indexName, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    private CompletableFuture<?> doMigrateAliases(URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases, OperationSubmitter operationSubmitter) {
        return this.schemaAccessor.updateAliases(indexName, aliases, operationSubmitter);
    }

    private CompletableFuture<?> doMigrateSettings(URLEncodedString indexName, IndexSettings expectedSettings, IndexSettings actualSettings, OperationSubmitter operationSubmitter) {
        IndexSettings indexSettings = expectedSettings.diff(actualSettings.getExtraAttributes());
        return this.schemaAccessor.closeIndex(indexName, operationSubmitter).thenCompose(ignored -> Futures.whenCompleteExecute(this.schemaAccessor.updateSettings(indexName, indexSettings, operationSubmitter), () -> this.schemaAccessor.openIndex(indexName, operationSubmitter)));
    }

    private CompletableFuture<?> doMigrateMapping(URLEncodedString indexName, RootTypeMapping mapping, OperationSubmitter operationSubmitter) {
        return this.schemaAccessor.updateMapping(indexName, mapping, operationSubmitter);
    }
}

