/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.highlighter.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.util.common.impl.CollectionHelper;

public interface ElasticsearchSearchHighlighter
extends SearchHighlighter {
    public void request(JsonObject var1);

    public void applyToField(String var1, JsonObject var2);

    public Set<String> indexNames();

    public SearchHighlighterType type();

    public boolean isCompatible(ProjectionCollector.Provider<?, ?> var1);

    public static ElasticsearchSearchHighlighter from(ElasticsearchSearchIndexScope<?> scope, SearchHighlighter highlighter) {
        if (!(highlighter instanceof ElasticsearchSearchHighlighter)) {
            throw QueryLog.INSTANCE.cannotMixElasticsearchSearchQueryWithOtherQueryHighlighters(highlighter);
        }
        ElasticsearchSearchHighlighter casted = (ElasticsearchSearchHighlighter)highlighter;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw QueryLog.INSTANCE.queryHighlighterDefinedOnDifferentIndexes(highlighter, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }
}

