/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.common.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class ElasticsearchMatchIdPredicate
extends AbstractElasticsearchPredicate {
    private static final JsonObjectAccessor IDS_ACCESSOR = JsonAccessor.root().property("ids").asObject();
    private static final JsonAccessor<JsonElement> VALUES_ACCESSOR = JsonAccessor.root().property("values");
    private final DocumentIdHelper documentIdHelper;
    private final List<String> values;

    private ElasticsearchMatchIdPredicate(Builder builder) {
        super(builder);
        this.documentIdHelper = builder.scope.documentIdHelper();
        this.values = builder.values;
        builder.values = null;
    }

    @Override
    public void checkNestableWithin(PredicateNestingContext context) {
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonArray array = this.toJsonArray(this.values, context.getTenantId());
        VALUES_ACCESSOR.set(innerObject, (JsonElement)array);
        IDS_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private JsonArray toJsonArray(List<String> list, String tenantId) {
        JsonArray jsonArray = new JsonArray(list.size());
        for (String value : list) {
            jsonArray.add(this.documentIdHelper.toElasticsearchId(tenantId, value));
        }
        return jsonArray;
    }

    static class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements MatchIdPredicateBuilder {
        private List<String> values = new ArrayList<String>();

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public void value(Object value, ValueModel valueModel) {
            DslConverter converter = this.scope.identifier().dslConverter(valueModel);
            ToDocumentValueConvertContext context = this.scope.toDocumentValueConvertContext();
            this.values.add((String)converter.unknownTypeToDocumentValue(value, context));
        }

        public SearchPredicate build() {
            return new ElasticsearchMatchIdPredicate(this);
        }
    }
}

