/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.cfg.spi.NumberUtils;

public final class ElasticsearchFloatFieldCodec
extends AbstractElasticsearchFieldCodec<Float> {
    public ElasticsearchFloatFieldCodec(Gson gson) {
        super(gson);
    }

    @Override
    public JsonElement encode(Float value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Float decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.FLOAT.fromElement(element);
    }

    @Override
    public Float decode(Double value) {
        return NumberUtils.toFloat((Double)value);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return other instanceof ElasticsearchFloatFieldCodec;
    }
}

