/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchJsonElementFieldCodec
implements ElasticsearchFieldCodec<JsonElement> {
    private final Gson gson;

    public ElasticsearchJsonElementFieldCodec(Gson gson) {
        this.gson = gson;
    }

    @Override
    public JsonElement encode(JsonElement value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return value;
    }

    @Override
    public JsonElement decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return element;
    }

    @Override
    public JsonElement decode(Double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchJsonElementFieldCodec castedOther = (ElasticsearchJsonElementFieldCodec)other;
        return this.gson.equals(castedOther.gson);
    }

    @Override
    public JsonElement fromJsonStringToElement(String value) {
        return (JsonElement)this.gson.fromJson(value, JsonElement.class);
    }

    @Override
    public String fromJsonElementToString(JsonElement value) {
        return this.gson.toJson(value);
    }
}

