/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import java.math.BigDecimal;
import org.hibernate.search.backend.elasticsearch.logging.impl.MappingLog;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchBigDecimalFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchNumericFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultStringConverters;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;

class ElasticsearchBigDecimalIndexFieldTypeOptionsStep
extends AbstractElasticsearchNumericFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal>
implements ScaledNumberIndexFieldTypeOptionsStep<ElasticsearchBigDecimalIndexFieldTypeOptionsStep, BigDecimal> {
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    ElasticsearchBigDecimalIndexFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigDecimal.class, "scaled_float", DefaultStringConverters.BIG_DECIMAL);
        this.defaultsProvider = defaultsProvider;
    }

    public ElasticsearchBigDecimalIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this.thisAsS();
    }

    @Override
    protected ElasticsearchFieldCodec<BigDecimal> completeCodec(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        int resolvedDecimalScale = this.resolveDecimalScale();
        ElasticsearchBigDecimalFieldCodec codec = new ElasticsearchBigDecimalFieldCodec(buildContext.getUserFacingGson(), resolvedDecimalScale);
        this.builder.mapping().setScalingFactor(codec.scalingFactor().doubleValue());
        return codec;
    }

    @Override
    protected ElasticsearchBigDecimalIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.decimalScale() != null) {
            return this.defaultsProvider.decimalScale();
        }
        throw MappingLog.INSTANCE.nullDecimalScale(this.buildContext.hints().missingDecimalScale(), this.buildContext.getEventContext());
    }
}

